<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<xsl:stylesheet xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:saxon="http://saxon.sf.net/"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:schold="http://www.ascc.net/xml/schematron"
                xmlns:iso="http://purl.oclc.org/dsdl/schematron"
                xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:hl7="urn:hl7-org:v3"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                version="2.0"><!--Implementers: please note that overriding process-prolog or process-root is 
    the preferred method for meta-stylesheets to use where possible. -->
<xsl:param name="archiveDirParameter"/>
   <xsl:param name="archiveNameParameter"/>
   <xsl:param name="fileNameParameter"/>
   <xsl:param name="fileDirParameter"/>
   <xsl:variable name="document-uri">
      <xsl:value-of select="document-uri(/)"/>
   </xsl:variable>

   <!--PHASES-->


<!--PROLOG-->
<xsl:output method="text"/>

   <!--XSD TYPES FOR XSLT2-->


<!--KEYS AND FUNCTIONS-->


<!--DEFAULT RULES-->


<!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->
<xsl:template match="*" mode="schematron-select-full-path">
      <xsl:apply-templates select="." mode="schematron-get-full-path"/>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->
<xsl:template match="*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">
            <xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>*:</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>[namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="preceding"
                    select="count(preceding-sibling::*[local-name()=local-name(current())                                   and namespace-uri() = namespace-uri(current())])"/>
      <xsl:text>[</xsl:text>
      <xsl:value-of select="1+ $preceding"/>
      <xsl:text>]</xsl:text>
   </xsl:template>
   <xsl:template match="@*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">@<xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>@*[local-name()='</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>' and namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-2-->
<!--This mode can be used to generate prefixed XPath for humans-->
<xsl:template match="node() | @*" mode="schematron-get-full-path-2">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="preceding-sibling::*[name(.)=name(current())]">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>
   <!--MODE: SCHEMATRON-FULL-PATH-3-->
<!--This mode can be used to generate prefixed XPath for humans 
	(Top-level element has index)-->
<xsl:template match="node() | @*" mode="schematron-get-full-path-3">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="parent::*">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>

   <!--MODE: GENERATE-ID-FROM-PATH -->
<xsl:template match="/" mode="generate-id-from-path"/>
   <xsl:template match="text()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/>
   </xsl:template>
   <xsl:template match="comment()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/>
   </xsl:template>
   <xsl:template match="processing-instruction()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.@', name())"/>
   </xsl:template>
   <xsl:template match="*" mode="generate-id-from-path" priority="-0.5">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:text>.</xsl:text>
      <xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/>
   </xsl:template>

   <!--MODE: GENERATE-ID-2 -->
<xsl:template match="/" mode="generate-id-2">U</xsl:template>
   <xsl:template match="*" mode="generate-id-2" priority="2">
      <xsl:text>U</xsl:text>
      <xsl:number level="multiple" count="*"/>
   </xsl:template>
   <xsl:template match="node()" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>n</xsl:text>
      <xsl:number count="node()"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="string-length(local-name(.))"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="translate(name(),':','.')"/>
   </xsl:template>
   <!--Strip characters--><xsl:template match="text()" priority="-1"/>

   <!--SCHEMA SETUP-->
<xsl:template match="/">
      <xsl:apply-templates select="/" mode="M3"/>
      <xsl:apply-templates select="/" mode="M4"/>
      <xsl:apply-templates select="/" mode="M5"/>
      <xsl:apply-templates select="/" mode="M6"/>
      <xsl:apply-templates select="/" mode="M7"/>
      <xsl:apply-templates select="/" mode="M8"/>
   </xsl:template>

   <!--SCHEMATRON PATTERNS-->


<!--PATTERN xmlTest op processing instructions anders dan xml Test op gekoppelde XML Schema's Elementen Attributen-->


	<!--RULE -->
<xsl:template match="*[count(ancestor::*)=0]" priority="1006" mode="M3">
      <xsl:variable name="unparsed" select="unparsed-text(document-uri(/))"/>
      <xsl:variable name="firstprocessinginstruction"
                    select="substring-after(substring-before($unparsed, '?&gt;'),'&lt;?')"/>
      <xsl:variable name="declaration"
                    select="if (starts-with($firstprocessinginstruction,'xml')) then ($firstprocessinginstruction) else ()"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(contains($declaration,' version=')) or matches($declaration, 'version=.1\.0.')"/>
         <xsl:otherwise>
            <xsl:message>xml: het XML-prologattribuut moet versie 1.0 zijn. (not(contains($declaration,' version=')) or matches($declaration, 'version=.1\.0.') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(contains($declaration,' encoding=')) or matches($declaration, 'encoding=.(utf-8)|(UTF-8).')"/>
         <xsl:otherwise>
            <xsl:message>xml: het XML-prologattribuut encoding moet worden weggelaten of expliciet "UTF-8" zijn. (not(contains($declaration,' encoding=')) or matches($declaration, 'encoding=.(utf-8)|(UTF-8).') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="/processing-instruction('nictiz') or not(contains($declaration,' standalone='))"/>
         <xsl:otherwise>
            <xsl:message>xml: het XML-prologattribuut standalone mag niet worden gebruikt. (/processing-instruction('nictiz') or not(contains($declaration,' standalone=')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(//processing-instruction()) = 0 or /processing-instruction('nictiz')"/>
         <xsl:otherwise>
            <xsl:message>xml: de XML-prolog is de enig toegestane processing instruction. Bijvoorbeeld koppelingen naar stylesheets zijn niet toegestaan. (count(//processing-instruction()) = 0 or /processing-instruction('nictiz') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M3"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="*[@xsi:schemaLocation]" priority="1004" mode="M3">

		<!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="/processing-instruction('nictiz') or not(.)"/>
         <xsl:otherwise>
            <xsl:message>xml: er mogen geen XML Schema's zijn gekoppeld. Gevonden '<xsl:text/>
               <xsl:value-of select="@xsi:schemaLocation"/>
               <xsl:text/>' (/processing-instruction('nictiz') or not(.) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M3"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="*[@xsi:noNamespaceSchemaLocation]" priority="1003" mode="M3">

		<!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="/processing-instruction('nictiz') or not(.)"/>
         <xsl:otherwise>
            <xsl:message>xml: er mogen geen XML Schema's zijn gekoppeld. Gevonden '<xsl:text/>
               <xsl:value-of select="@xsi:noNamespaceSchemaLocation"/>
               <xsl:text/>' (/processing-instruction('nictiz') or not(.) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M3"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="*[@*[normalize-space()='']]" priority="1000" mode="M3">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>xml: attributen moeten een waarde hebben (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M3"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M3"/>
   <xsl:template match="@*|node()" priority="-2" mode="M3">
      <xsl:apply-templates select="*" mode="M3"/>
   </xsl:template>

   <!--PATTERN PRPM_IN907020NL02-wrapperTransmission Wrapper Algemeen Transmission Wrapper, geen batch MCCI_IN200101-->


	<!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:id" priority="1024" mode="M4">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn (not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: AGB-code moet 8 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef (not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue" select="@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: @extension moet een geldige interactie-id bevatten (not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@root and @extension"/>
         <xsl:otherwise>
            <xsl:message>Transmission: id element mist root of extension (@root and @extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M4"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:creationTime" priority="1023" mode="M4">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-QTY: no uncertainty (not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-QTY: no history or updateMode (count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@nullFlavor or @value or *) and not(@nullFlavor and @value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-TS: null or value or child element in case of extension ((@nullFlavor or @value or *) and not(@nullFlavor and @value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@xsi:type) or @xsi:type='TS' or ends-with(@xsi:type,':TS')"/>
         <xsl:otherwise>
            <xsl:message>Transmission: creationTime moet datatype TS hebben. Gevonden '<xsl:text/>
               <xsl:value-of select="@xsi:type"/>
               <xsl:text/>' (not(@xsi:type) or @xsi:type='TS' or ends-with(@xsi:type,':TS') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length(@value)&gt;13"/>
         <xsl:otherwise>
            <xsl:message>Transmission: creationTime moet minimaal op de seconde nauwkeurig zijn (string-length(@value)&gt;13 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M4"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:versionCode" priority="1022" mode="M4">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CS: @code/@typeCode and @nullFlavor are mutually exclusive ((@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystem)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CS: cannot have codeSystem (not(@codeSystem) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CS: cannot have codeSystemName (not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CS: cannot have codeSystemVersion (not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CS: cannot have displayName (not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CS: cannot have originalText (not(hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CS: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CS: cannot have translation (not(hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@code='NICTIZEd2005-Okt'"/>
         <xsl:otherwise>
            <xsl:message>Transmission: versionCode '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' moet 'NICTIZEd2005-Okt' zijn (@code='NICTIZEd2005-Okt' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M4"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:interactionId" priority="1021" mode="M4">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn (not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: AGB-code moet 8 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef (not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue" select="@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: @extension moet een geldige interactie-id bevatten (not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="interactionId"
                    select="self::node()[@root='2.16.840.1.113883.1.6']/@extension"/>
      <xsl:variable name="interactionVocabFile" select="'../vocab/2.16.840.1.113883.1.6.xml'"/>
      <xsl:variable name="interactionName"
                    select="if (doc-available($interactionVocabFile)) then (document($interactionVocabFile)/*/hl7:code[@code=$interactionId]/@displayName) else ()"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@root='2.16.840.1.113883.1.6'"/>
         <xsl:otherwise>
            <xsl:message>Transmission: @root moet '2.16.840.1.113883.1.6' zijn (@root='2.16.840.1.113883.1.6' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.1.6') or local-name(..)=@extension"/>
         <xsl:otherwise>
            <xsl:message>Transmission: @extension moet overeenkomen met het startelement van het bericht (not(@root='2.16.840.1.113883.1.6') or local-name(..)=@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(contains(@extension,':'))"/>
         <xsl:otherwise>
            <xsl:message>Transmission: @extension mag geen namespace prefix bevatten (not(contains(@extension,':')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(doc-available($interactionVocabFile)) or              not(document($interactionVocabFile)/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='Actief']/@value='false')"/>
         <xsl:otherwise>
            <xsl:message>Transmission: interaction-id <xsl:text/>
               <xsl:value-of select="$interactionId"/>
               <xsl:text/> (<xsl:text/>
               <xsl:value-of select="$interactionName"/>
               <xsl:text/>) is niet (meer) Actief in <xsl:text/>
               <xsl:value-of select="$interactionVocabFile"/>
               <xsl:text/> (not(doc-available($interactionVocabFile)) or not(document($interactionVocabFile)/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='Actief']/@value='false') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M4"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:profileId" priority="1020" mode="M4">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn (not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: AGB-code moet 8 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef (not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue" select="@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: @extension moet een geldige interactie-id bevatten (not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@root='2.16.840.1.113883.2.4.3.11.1' and (@extension='810')"/>
         <xsl:otherwise>
            <xsl:message>Transmission: profileId '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' moet gelijk zijn aan 810.  (@root='2.16.840.1.113883.2.4.3.11.1' and (@extension='810') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(following-sibling::hl7:profileId)"/>
         <xsl:otherwise>
            <xsl:message>Transmission: er mag maar één profileId worden gebruikt (not(following-sibling::hl7:profileId) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M4"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:acknowledgement" priority="1019" mode="M4">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="local-name(..)='MCCI_IN000002' or @typeCode='AA' or @typeCode='AE' or @typeCode='AR'"/>
         <xsl:otherwise>
            <xsl:message>Transmission: applicatieantwoorden moeten acknowledgement/@typeCode AA, AE of AR hebben (local-name(..)='MCCI_IN000002' or @typeCode='AA' or @typeCode='AE' or @typeCode='AR' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="not(local-name(..)='MCCI_IN000002') or @typeCode='CA' or @typeCode='CE' or @typeCode='CR'"/>
         <xsl:otherwise>
            <xsl:message>Transmission: ontvangstbevestigingen moeten acknowledgement/@typeCode CA, CE of CR hebben. In slechts sommige gevallen worden 
            toch inhoudelijke antwoorden toegestaan (@typeCode is 'AA', 'AE' or 'AR'). (not(local-name(..)='MCCI_IN000002') or @typeCode='CA' or @typeCode='CE' or @typeCode='CR' / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:targetMessage/hl7:id[@root and @extension] or hl7:targetTransmission/hl7:id[@root and @extension]"/>
         <xsl:otherwise>
            <xsl:message>Transmission: in antwoordinteracties moet de interactie waarop wordt geantwoord, worden geïdentificeerd in het element targetTransmission/id (hl7:targetMessage/hl7:id[@root and @extension] or hl7:targetTransmission/hl7:id[@root and @extension] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="@typeCode='AA' or @typeCode='CA' or hl7:acknowledgementDetail or ../hl7:ControlActProcess/hl7:reason or ../hl7:ControlActProcess/hl7:reasonOf"/>
         <xsl:otherwise>
            <xsl:message>Transmission: negatieve antwoordberichten moeten ook een reden hebben waarom (@typeCode='AA' or @typeCode='CA' or hl7:acknowledgementDetail or ../hl7:ControlActProcess/hl7:reason or ../hl7:ControlActProcess/hl7:reasonOf / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M4"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:acknowledgement/hl7:acknowledgementDetail"
                 priority="1018"
                 mode="M4">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@typeCode) or @typeCode='E'"/>
         <xsl:otherwise>
            <xsl:message>Transmission: acknowledgementDetail/@typeCode moet indien aanwezig E (Error) zijn. W (Warning) of I (Information) zijn niet toegestaan (not(@typeCode) or @typeCode='E' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:code"/>
         <xsl:otherwise>
            <xsl:message>Transmission: acknowledgementDetail/code moet een waarde hebben. (hl7:code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:code[@code and @displayName] or hl7:text"/>
         <xsl:otherwise>
            <xsl:message>Transmission: er moet een toelichting op de fout/waarschuwing zijn in hl7:code/@displayName of text (hl7:code[@code and @displayName] or hl7:text / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M4"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:acknowledgement/hl7:acknowledgementDetail/hl7:code"
                 priority="1017"
                 mode="M4">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@code or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@code))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CD: no code if null (not(@nullFlavor) or (@nullFlavor and not(@code)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CD: no displayName if null (not(@nullFlavor) or (@nullFlavor and not(@displayName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CD: no originalText on translations (not(hl7:translation/hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-CD: no null on translations (not(hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-11-CD: translation code requires codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@code or not(hl7:translation/@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-14-CD: translation displayName only if code (hl7:translation/@code or not(hl7:translation/@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="matches(@displayName,'[\r\n\t]')">
         <xsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to
        interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="code" select="@code"/>

		    <!--REPORT warning-->
<xsl:if test="@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))">
         <xsl:message>Datatype CD: waarschuwing: onbekend codeSystem '<xsl:text/>
            <xsl:value-of select="@codeSystem"/>
            <xsl:text/>' gevonden met codeSystemName 
        '<xsl:text/>
            <xsl:value-of select="./@codeSystemName"/>
            <xsl:text/>'. Bestand '<xsl:text/>
            <xsl:value-of select="concat('../vocab/',@codeSystem,'.xml')"/>
            <xsl:text/>' ontbreekt. (@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml'))) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="hl7:translation[@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))]">
         <xsl:message>Datatype CD: waarschuwing: onbekend codeSystem '<xsl:text/>
            <xsl:value-of select="hl7:translation/@codeSystem"/>
            <xsl:text/>' in translation (hl7:translation[@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="if (@codeSystem and doc-available(concat('../vocab/',@codeSystem,'.xml')) and (         document(concat('../vocab/',@codeSystem,'.xml'))/*[@codeStrength='CNE'] or         not(document(concat('../vocab/',@codeSystem,'.xml'))/*/@codeStrength))) then (          not(document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:code[@code=$code]) ) else ( 0=1 )">
         <xsl:message>Datatype CD: waarschuwing: onbekende code '<xsl:text/>
            <xsl:value-of select="$code"/>
            <xsl:text/>' gevonden in codeSystem '<xsl:text/>
            <xsl:value-of select="@codeSystem"/>
            <xsl:text/>'
        gevonden met displayName '<xsl:text/>
            <xsl:value-of select="./@displayName"/>
            <xsl:text/>'. Waarde ontbreekt in 
        '<xsl:text/>
            <xsl:value-of select="concat('../vocab/',@codeSystem,'.xml')"/>
            <xsl:text/>' (<xsl:text/>
            <xsl:value-of select="document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:name"/>
            <xsl:text/>). (if (@codeSystem and doc-available(concat('../vocab/',@codeSystem,'.xml')) and ( document(concat('../vocab/',@codeSystem,'.xml'))/*[@codeStrength='CNE'] or not(document(concat('../vocab/',@codeSystem,'.xml'))/*/@codeStrength))) then ( not(document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:code[@code=$code]) ) else ( 0=1 ) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no originalText on translations (not(hl7:translation/hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no translation on translations (not(hl7:translation/hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no null on translations (not(hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@code)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation code requires codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation codeSystemName only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation codeSystemVersion only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@code or not(hl7:translation/@displayName)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation displayName only if code (hl7:translation/@code or not(hl7:translation/@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="self::hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(../hl7:id/@root='2.16.528.1.1007.3.1') or          document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: UZI rolcode attribuut code moet een geldige RoleCodeNL bevatten (not(../hl7:id/@root='2.16.528.1.1007.3.1') or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="self::hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or not(../hl7:id/@root='2.16.528.1.1007.3.3') or          document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: organisatie rolcode attribuut code moet een geldige AssignedRoleType bevatten (@nullFlavor or not(../hl7:id/@root='2.16.528.1.1007.3.3') or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CE: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nulFlavor)"/>
         <xsl:otherwise>
            <xsl:message>Transmission: code moet een waarde hebben. (not(@nulFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>Transmission: code mag geen translation bevatten. (not(hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="not(@codeSystem='2.16.840.1.113883.5.1100' or @codeSystem='2.16.840.1.113883.2.4.6.6.1.1000' or @codeSystem='2.16.840.1.113883.5.4') and not(@displayName)">
         <xsl:message>Transmission: als de code niet uit een van de standaardcodesystemen '2.16.840.1.113883.5.1100', '2.16.840.1.113883.2.4.6.6.1.1000', of '2.16.840.1.113883.5.4' komt is het @displayName attribuut verplicht (not(@codeSystem='2.16.840.1.113883.5.1100' or @codeSystem='2.16.840.1.113883.2.4.6.6.1.1000' or @codeSystem='2.16.840.1.113883.5.4') and not(@displayName) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:apply-templates select="*" mode="M4"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:receiver" priority="1016" mode="M4">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@typeCode) or @typeCode='RCV'"/>
         <xsl:otherwise>
            <xsl:message>Transmission: receiver/@typeCode moet 'RCV' zijn indien aanwezig (not(@typeCode) or @typeCode='RCV' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(../hl7:receiver)=1"/>
         <xsl:otherwise>
            <xsl:message>Transmission: receiver mag slechts éénmaal voorkomen (count(../hl7:receiver)=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M4"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:respondTo" priority="1015" mode="M4">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@typeCode) or @typeCode='RSP'"/>
         <xsl:otherwise>
            <xsl:message>Transmission: respondTo/@typeCode moet 'RSP' zijn indien aanwezig (not(@typeCode) or @typeCode='RSP' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(../hl7:respondTo)=1"/>
         <xsl:otherwise>
            <xsl:message>Transmission: respondTo mag slechts éénmaal voorkomen (count(../hl7:respondTo)=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(hl7:entityRsp)=1"/>
         <xsl:otherwise>
            <xsl:message>Transmission: respondTo/entityRsp mag slechts éénmaal voorkomen (count(hl7:entityRsp)=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="entityRspRoot" select="hl7:entityRsp/hl7:id/@root"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="not(hl7:entityRsp/hl7:id/@extension=../hl7:sender/hl7:device/hl7:id[@root=$entityRspRoot]/@extension)"/>
         <xsl:otherwise>
            <xsl:message>Transmission: waarschuwing: het antwoord moet worden verstuurd aan dezelfde applicatie als de zendende applicatie. In dit geval is respondTo redundant. (not(hl7:entityRsp/hl7:id/@extension=../hl7:sender/hl7:device/hl7:id[@root=$entityRspRoot]/@extension) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M4"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:sender" priority="1014" mode="M4">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@typeCode) or @typeCode='SND'"/>
         <xsl:otherwise>
            <xsl:message>Transmission: sender/@typeCode moet 'SND' zijn indien aanwezig (not(@typeCode) or @typeCode='SND' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M4"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:attentionLine" priority="1013" mode="M4">
      <xsl:variable name="interactionId"
                    select="../hl7:interactionId[@root='2.16.840.1.113883.1.6']/@extension"/>
      <xsl:variable name="interactionVocabFile" select="'../vocab/2.16.840.1.113883.1.6.xml'"/>
      <xsl:variable name="interactionName"
                    select="if (doc-available($interactionVocabFile)) then (document($interactionVocabFile)/*/hl7:code[@code=$interactionId]/@displayName) else ()"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="not(doc-available($interactionVocabFile)) or              document($interactionVocabFile)/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='AttentionLineMetBsn']/@value='true' or             ../hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant/hl7:AssignedPerson/hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.8'] or             ../hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant/hl7:AssignedPerson/hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.6']"/>
         <xsl:otherwise>
            <xsl:message>Transmission: interaction-id <xsl:text/>
               <xsl:value-of select="$interactionId"/>
               <xsl:text/> (<xsl:text/>
               <xsl:value-of select="$interactionName"/>
               <xsl:text/>) is niet geconfigureerd voor gebruik van het element <xsl:text/>
               <xsl:value-of select="local-name()"/>
               <xsl:text/> in <xsl:text/>
               <xsl:value-of select="$interactionVocabFile"/>
               <xsl:text/> en afzender is niet GBK of GBP (not(doc-available($interactionVocabFile)) or document($interactionVocabFile)/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='AttentionLineMetBsn']/@value='true' or ../hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant/hl7:AssignedPerson/hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.8'] or ../hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant/hl7:AssignedPerson/hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.6'] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M4"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:id | hl7:respondTo/hl7:entityRsp/hl7:id"
                 priority="1012"
                 mode="M4">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn (not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: AGB-code moet 8 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef (not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue" select="@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: @extension moet een geldige interactie-id bevatten (not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@root='2.16.840.1.113883.2.4.6.6' and @extension"/>
         <xsl:otherwise>
            <xsl:message>Transmission: <xsl:text/>
               <xsl:value-of select="local-name(../..)"/>
               <xsl:text/>/<xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/id/@root moet 2.16.840.1.113883.2.4.6.6 zijn (@root='2.16.840.1.113883.2.4.6.6' and @extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M4"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:desc"
                 priority="1011"
                 mode="M4">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>Transmission: <xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/device/descr mag niet gebruikt worden. (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M4"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:existenceTime"
                 priority="1010"
                 mode="M4">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>Transmission: <xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/device/existenceTime mag niet gebruikt worden. (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M4"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:manufacturerModelName"
                 priority="1009"
                 mode="M4">

		<!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>Transmission: <xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/device/manufacturerModelName niet gebruiken. (not(.) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M4"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:agencyFor"
                 priority="1008"
                 mode="M4">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@classCode) or @classCode='AGNT'"/>
         <xsl:otherwise>
            <xsl:message>Transmission: <xsl:text/>
               <xsl:value-of select="local-name(../..)"/>
               <xsl:text/>/<xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/agencyFor/@classCode moet, indien aanwezig de waarde "AGNT" bevatten (not(@classCode) or @classCode='AGNT' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M4"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:agencyFor/hl7:representedOrganization"
                 priority="1007"
                 mode="M4">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@classCode) or @classCode='ORG'"/>
         <xsl:otherwise>
            <xsl:message>Transmission: <xsl:text/>
               <xsl:value-of select="local-name(../../..)"/>
               <xsl:text/>/<xsl:text/>
               <xsl:value-of select="local-name(../..)"/>
               <xsl:text/>/agencyFor/representedOrganization/@classCode moet, indien aanwezig de waarde "ORG" bevatten (not(@classCode) or @classCode='ORG' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@determinerCode) or @determinerCode='INSTANCE'"/>
         <xsl:otherwise>
            <xsl:message>Transmission: <xsl:text/>
               <xsl:value-of select="local-name(../../..)"/>
               <xsl:text/>/<xsl:text/>
               <xsl:value-of select="local-name(../..)"/>
               <xsl:text/>/agencyFor/representedOrganization/@determinerCode moet, indien aanwezig de waarde "INSTANCE" bevatten (not(@determinerCode) or @determinerCode='INSTANCE' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(hl7:id)=1"/>
         <xsl:otherwise>
            <xsl:message>Transmission: <xsl:text/>
               <xsl:value-of select="local-name(../../..)"/>
               <xsl:text/>/<xsl:text/>
               <xsl:value-of select="local-name(../..)"/>
               <xsl:text/>/agencyFor/representedOrganization/id mag maar één maal voorkomen (count(hl7:id)=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M4"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:agencyFor/hl7:representedOrganization/hl7:name"
                 priority="1006"
                 mode="M4">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-EN: entity name shall be null or text only or element only (no mixed content) (@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="*[not(@nullFlavor)][normalize-space(.)='']">
         <xsl:message>dtr1-3-EN: empty name particles should not be present. (*[not(@nullFlavor)][normalize-space(.)=''] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="substring(normalize-space(.),1,1)='&#34;'">
         <xsl:message>dtr1-4-EN: Use of quotes at the beginning of a name are probably not correct. (substring(normalize-space(.),1,1)='"' / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(hl7:family)=0 and count(hl7:given)=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ON: no parts may be person name type particles (count(hl7:family)=0 and count(hl7:given)=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(*)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-ON: organization names SHALL be element content (not(*) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M4"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:agencyFor/hl7:representedOrganization/hl7:telecom"
                 priority="1005"
                 mode="M4">
      <xsl:variable name="urlScheme" select="substring-before(@value,':')"/>
      <xsl:variable name="urlStr" select="substring-after(@value,':')"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-URL: elements of type URL SHALL have a @value attribute. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value=iri-to-uri(@value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-URL: @value must be a valid URI, e.g. '<xsl:text/>
               <xsl:value-of select="iri-to-uri(@value)"/>
               <xsl:text/>'. (@value=iri-to-uri(@value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: Telecom elementen moeten een value attribuut hebben. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value=iri-to-uri(@value)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: Een telecom value moet een geldige URI zijn, bijvoorbeeld '<xsl:text/>
               <xsl:value-of select="iri-to-uri(@value)"/>
               <xsl:text/>'. (@value=iri-to-uri(@value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="urlScheme" select="substring-before(@value,':')"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value and document('../vocab/URL-urlScheme.xml')/*/hl7:code[@code=$urlScheme]"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: Telecom value moet een in Nederland geldig URL scheme hebben. Gevonden '<xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/>' (@value and document('../vocab/URL-urlScheme.xml')/*/hl7:code[@code=$urlScheme] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="urlStr" select="substring-after(@value,':')"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='tel' or $urlScheme='fax') then (         matches($urlStr,'^(\+?([\d()./-]|(%[a-f\d]{2}))+)*(;(phone-context=((\+?([\d()./-]|(%[a-f\d]{2}))+)|(([a-z\d-]|(%[a-f\d]{2}))+(\.([a-z\d-]|(%[a-f\d]{2}))+)*))|(ext=[\d./-]+)|(isub=(([a-z\d();/?:@&amp;=+$,_.!~*-])|(%[a-f\d]{2}))+)|([a-z\d-]+=([a-z\d\[\]/:&amp;+$_.!~*()-]|(%[a-f\d]{2}))+)))*$')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 3966 (if ($urlScheme='tel' or $urlScheme='fax') then ( matches($urlStr,'^(\+?([\d()./-]|(%[a-f\d]{2}))+)*(;(phone-context=((\+?([\d()./-]|(%[a-f\d]{2}))+)|(([a-z\d-]|(%[a-f\d]{2}))+(\.([a-z\d-]|(%[a-f\d]{2}))+)*))|(ext=[\d./-]+)|(isub=(([a-z\d();/?:@&amp;=+$,_.!~*-])|(%[a-f\d]{2}))+)|([a-z\d-]+=([a-z\d\[\]/:&amp;+$_.!~*()-]|(%[a-f\d]{2}))+)))*$') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc3966)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='file') then (         matches($urlStr,'^///{0,2}((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 1738. (if ($urlScheme='file') then ( matches($urlStr,'^///{0,2}((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc1738)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='nfs') then (         matches($urlStr,'^//((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))/?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 2224. (if ($urlScheme='nfs') then ( matches($urlStr,'^//((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))/?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc2224)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='ftp' or $urlScheme='ftps') then (         matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;=~_-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z][\w-]*))?)?(/(([a-z\d$\.+!*(),?&amp;_~=-])|(%[a-f\d]{2}))*)*(;type=[aid])?$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 1738. (if ($urlScheme='ftp' or $urlScheme='ftps') then ( matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;=~_-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z][\w-]*))?)?(/(([a-z\d$\.+!*(),?&amp;_~=-])|(%[a-f\d]{2}))*)*(;type=[aid])?$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc1738)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='http' or $urlScheme='https') then (         matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*(\?(([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*(&amp;((([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*)?)*)?(#([\w~!$+|.,*:=~_]|%[a-f\d]{2})*)?$', 'i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 1738 (if ($urlScheme='http' or $urlScheme='https') then ( matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*(\?(([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*(&amp;((([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*)?)*)?(#([\w~!$+|.,*:=~_]|%[a-f\d]{2})*)?$', 'i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc1738)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='telnet') then (         matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)*$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 1738. (if ($urlScheme='telnet') then ( matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)*$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc1738)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='mailto') then (         matches($urlStr,'^[\w$\.+!*(),?&amp;~_=-]+(\.[\w$\.+!*(),?&amp;~_=-]+)*@([\w$+!*(),?&amp;~_=-]+\.)+([a-z]{2,4})$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 2368. Merk op dat het niet toegestaan is extra headers op te nemen (if ($urlScheme='mailto') then ( matches($urlStr,'^[\w$\.+!*(),?&amp;~_=-]+(\.[\w$\.+!*(),?&amp;~_=-]+)*@([\w$+!*(),?&amp;~_=-]+\.)+([a-z]{2,4})$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc2368)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='x-hl7-applicatie') then (         matches($urlStr,'^2\.16\.840\.1\.113883\.2\.4\.6\.6\.[1-9]\d+$')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten beginnen met "2.16.840.1.113883.2.4.6.6." gevolgd door een numeriek deel (if ($urlScheme='x-hl7-applicatie') then ( matches($urlStr,'^2\.16\.840\.1\.113883\.2\.4\.6\.6\.[1-9]\d+$') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='mllp') then (         matches($urlStr,'^//(([1-2]\d{0,2})(\.([1-2]\d{0,2})){3}|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2}))):(([1-9]\d{0,4})|([A-Za-z]\w*))/$')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan mllp://host:port/ waarbij 'host' een naam of IP kan zijn en 'port' een benoemde poort of een nummer (if ($urlScheme='mllp') then ( matches($urlStr,'^//(([1-2]\d{0,2})(\.([1-2]\d{0,2})){3}|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2}))):(([1-9]\d{0,4})|([A-Za-z]\w*))/$') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor and hl7:usablePeriod)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-TEL: not null and usablePeriod (not(@nullFlavor and hl7:usablePeriod) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M4"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:*[local-name()='receiver' or local-name()='sender']/hl7:device/hl7:location"
                 priority="1004"
                 mode="M4">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>Transmission: <xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/device/location mag niet gebruikt worden. (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M4"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:processingCode" priority="1002" mode="M4">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CS: @code/@typeCode and @nullFlavor are mutually exclusive ((@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystem)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CS: cannot have codeSystem (not(@codeSystem) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CS: cannot have codeSystemName (not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CS: cannot have codeSystemVersion (not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CS: cannot have displayName (not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CS: cannot have originalText (not(hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CS: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CS: cannot have translation (not(hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="@code='P' or document(document-uri(/))/processing-instruction('nictiz')"/>
         <xsl:otherwise>
            <xsl:message>Transmission: processingCode moet in productie altijd gelijk zijn aan P (productie). D (debug) en T (training) zijn dan niet toegestaan (@code='P' or document(document-uri(/))/processing-instruction('nictiz') / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@code='P' or @code='T' or @code='D'"/>
         <xsl:otherwise>
            <xsl:message>Transmission: processingCode moet de waarde P (productie). D (debug) of T (training) bevatten (@code='P' or @code='T' or @code='D' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M4"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:processingModeCode" priority="1001" mode="M4">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CS: @code/@typeCode and @nullFlavor are mutually exclusive ((@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystem)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CS: cannot have codeSystem (not(@codeSystem) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CS: cannot have codeSystemName (not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CS: cannot have codeSystemVersion (not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CS: cannot have displayName (not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CS: cannot have originalText (not(hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CS: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CS: cannot have translation (not(hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@code='T'"/>
         <xsl:otherwise>
            <xsl:message>Transmission: processingModeCode moet gelijk zijn aan T (Current processing). A (Archive), I (Initial load), en R (Restore from archive) zijn niet toegestaan (@code='T' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M4"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:acceptAckCode" priority="1000" mode="M4">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CS: @code/@typeCode and @nullFlavor are mutually exclusive ((@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystem)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CS: cannot have codeSystem (not(@codeSystem) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CS: cannot have codeSystemName (not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CS: cannot have codeSystemVersion (not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CS: cannot have displayName (not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CS: cannot have originalText (not(hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CS: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CS: cannot have translation (not(hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@code='NE' or @code='AL'"/>
         <xsl:otherwise>
            <xsl:message>Transmission: acceptAckCode moet gelijk zijn aan NE (never) of AL (always) (@code='NE' or @code='AL' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M4"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M4"/>
   <xsl:template match="@*|node()" priority="-2" mode="M4">
      <xsl:apply-templates select="*" mode="M4"/>
   </xsl:template>

   <!--PATTERN PRPM_IN907020NL02-controlActControlActProcess ControlActProcess/reason en ControlActProcess/reasonOf ControlActProcess/registrationProcess ControlActProcess/registrationProcess/id ControlActProcess/registrationProcess/code ControlActProcess/registrationProcess/statusCode ControlActProcess/registrationProcess/effectiveTime ControlActProcess/queryByParameter ControlActProcess/queryAck ControlActProcess/informationRecipient ControlActProcess/dataEnterer ControlActProcess/authorOrPerformer ControlActProcess/authorOrPerformer/AssignedPerson ControlActProcess/authorOrPerformer/participant/AssignedPerson/id ControlActProcess/authorOrPerformer/AssignedDevice ControlActProcess/authorOrPerformer/participant/AssignedDevice/id ControlActProcess/overseer ControlActProcess/overseer/AssignedPerson en ControlActProcess/overseer/assignedEntity-->


	<!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess" priority="1090" mode="M5">
      <xsl:variable name="interactionId" select="local-name(..)"/>
      <xsl:variable name="interactionVocab" select="'../vocab/2.16.840.1.113883.1.6.xml'"/>
      <xsl:variable name="interactionTrustLevel"
                    select="document($interactionVocab)/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='Vertrouwensniveau']/@value"/>
      <xsl:variable name="interactionSendType"
                    select="document($interactionVocab)/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='Verzendtype']/@value"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:authorOrPerformer[hl7:participant/hl7:AssignedPerson] or not($interactionTrustLevel) or $interactionTrustLevel='Laag'"/>
         <xsl:otherwise>
            <xsl:message>Control Act: ControlActProcess/authorOrPerformer moet een persoon bevatten in berichten met vertrouwensniveau midden of hoog (hl7:authorOrPerformer[hl7:participant/hl7:AssignedPerson] or not($interactionTrustLevel) or $interactionTrustLevel='Laag' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:overseer or not($interactionTrustLevel) or $interactionTrustLevel='Laag'"/>
         <xsl:otherwise>
            <xsl:message>Control Act: ControlActProcess/overseer moet de mandaterende persoon bevatten in berichten met vertrouwensniveau midden of hoog (hl7:overseer or not($interactionTrustLevel) or $interactionTrustLevel='Laag' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:queryByParameter) or @moodCode='EVN'"/>
         <xsl:otherwise>
            <xsl:message>Control Act: ControlActProcess moodCode moet EVN zijn bij queries (not(hl7:queryByParameter) or @moodCode='EVN' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:id" priority="1089"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn (not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: AGB-code moet 8 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef (not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue" select="@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: @extension moet een geldige interactie-id bevatten (not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:code" priority="1088"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@code or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@code))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CD: no code if null (not(@nullFlavor) or (@nullFlavor and not(@code)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CD: no displayName if null (not(@nullFlavor) or (@nullFlavor and not(@displayName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CD: no originalText on translations (not(hl7:translation/hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-CD: no null on translations (not(hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-11-CD: translation code requires codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@code or not(hl7:translation/@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-14-CD: translation displayName only if code (hl7:translation/@code or not(hl7:translation/@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="matches(@displayName,'[\r\n\t]')">
         <xsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to
        interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="code" select="@code"/>

		    <!--REPORT warning-->
<xsl:if test="@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))">
         <xsl:message>Datatype CD: waarschuwing: onbekend codeSystem '<xsl:text/>
            <xsl:value-of select="@codeSystem"/>
            <xsl:text/>' gevonden met codeSystemName 
        '<xsl:text/>
            <xsl:value-of select="./@codeSystemName"/>
            <xsl:text/>'. Bestand '<xsl:text/>
            <xsl:value-of select="concat('../vocab/',@codeSystem,'.xml')"/>
            <xsl:text/>' ontbreekt. (@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml'))) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="hl7:translation[@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))]">
         <xsl:message>Datatype CD: waarschuwing: onbekend codeSystem '<xsl:text/>
            <xsl:value-of select="hl7:translation/@codeSystem"/>
            <xsl:text/>' in translation (hl7:translation[@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="if (@codeSystem and doc-available(concat('../vocab/',@codeSystem,'.xml')) and (         document(concat('../vocab/',@codeSystem,'.xml'))/*[@codeStrength='CNE'] or         not(document(concat('../vocab/',@codeSystem,'.xml'))/*/@codeStrength))) then (          not(document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:code[@code=$code]) ) else ( 0=1 )">
         <xsl:message>Datatype CD: waarschuwing: onbekende code '<xsl:text/>
            <xsl:value-of select="$code"/>
            <xsl:text/>' gevonden in codeSystem '<xsl:text/>
            <xsl:value-of select="@codeSystem"/>
            <xsl:text/>'
        gevonden met displayName '<xsl:text/>
            <xsl:value-of select="./@displayName"/>
            <xsl:text/>'. Waarde ontbreekt in 
        '<xsl:text/>
            <xsl:value-of select="concat('../vocab/',@codeSystem,'.xml')"/>
            <xsl:text/>' (<xsl:text/>
            <xsl:value-of select="document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:name"/>
            <xsl:text/>). (if (@codeSystem and doc-available(concat('../vocab/',@codeSystem,'.xml')) and ( document(concat('../vocab/',@codeSystem,'.xml'))/*[@codeStrength='CNE'] or not(document(concat('../vocab/',@codeSystem,'.xml'))/*/@codeStrength))) then ( not(document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:code[@code=$code]) ) else ( 0=1 ) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no originalText on translations (not(hl7:translation/hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no translation on translations (not(hl7:translation/hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no null on translations (not(hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@code)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation code requires codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation codeSystemName only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation codeSystemVersion only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@code or not(hl7:translation/@displayName)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation displayName only if code (hl7:translation/@code or not(hl7:translation/@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="self::hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(../hl7:id/@root='2.16.528.1.1007.3.1') or          document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: UZI rolcode attribuut code moet een geldige RoleCodeNL bevatten (not(../hl7:id/@root='2.16.528.1.1007.3.1') or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="self::hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or not(../hl7:id/@root='2.16.528.1.1007.3.3') or          document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: organisatie rolcode attribuut code moet een geldige AssignedRoleType bevatten (@nullFlavor or not(../hl7:id/@root='2.16.528.1.1007.3.3') or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem='2.16.840.1.113883.1.18'"/>
         <xsl:otherwise>
            <xsl:message>ControlActProcess/code moet uit codeSystem '2.16.840.1.113883.1.18' komen (@codeSystem='2.16.840.1.113883.1.18' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue" select="@code"/>
      <xsl:variable name="interactionId" select="../../hl7:interactionId/@extension"/>
      <xsl:variable name="vocabFile"
                    select="concat('../vocab/',../../hl7:interactionId/@root,'.xml')"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="document($vocabFile)/*/hl7:code[@code=$interactionId]/hl7:reference[@extension=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Control Act: ControlActProcess/code (Trigger Event) moet bij deze interactie 
            '<xsl:text/>
               <xsl:value-of select="document($vocabFile)/*/hl7:code[@code=$interactionId]/hl7:reference/@extension"/>
               <xsl:text/>'
            zijn, gevonden is echter '<xsl:text/>
               <xsl:value-of select="$codeValue"/>
               <xsl:text/>' (document($vocabFile)/*/hl7:code[@code=$interactionId]/hl7:reference[@extension=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:text" priority="1087"
                 mode="M5">

		<!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/<xsl:text/>
               <xsl:value-of select="local-name()"/>
               <xsl:text/> niet gebruiken (false() / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:effectiveTime"
                 priority="1086"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-QTY: no uncertainty (not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-QTY: no history or updateMode (count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@nullFlavor or @value or *) and not(@nullFlavor and @value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-TS: null or value or child element in case of extension ((@nullFlavor or @value or *) and not(@nullFlavor and @value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@xsi:type='TS' or ends-with(@xsi:type,':TS')) or (not(@xsi:type) and @value)"/>
         <xsl:otherwise>
            <xsl:message>Control Act: ControlActProcess/effectiveTime moet datatype TS hebben ((@xsi:type='TS' or ends-with(@xsi:type,':TS')) or (not(@xsi:type) and @value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:reasonCode"
                 priority="1085"
                 mode="M5">

		<!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/<xsl:text/>
               <xsl:value-of select="local-name()"/>
               <xsl:text/> niet gebruiken (false() / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:languageCode"
                 priority="1084"
                 mode="M5">

		<!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/<xsl:text/>
               <xsl:value-of select="local-name()"/>
               <xsl:text/> niet gebruiken (false() / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/*[self::hl7:reasonOf or self::hl7:reason]/*[self::hl7:justifiedDetectedIssue or self::hl7:justifyingDetectedIssueEvent]"
                 priority="1082"
                 mode="M5">

		<!--REPORT warning-->
<xsl:if test="not(hl7:code[@code and @displayName] or hl7:text or hl7:value)">
         <xsl:message>Control Act: Bij voorkeur moet code/@displayName, text of value een uitgebreidere toelichting op de fout/waarschuwing hebben (not(hl7:code[@code and @displayName] or hl7:text or hl7:value) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/*[self::hl7:reasonOf or self::hl7:reason]/*[self::hl7:justifiedDetectedIssue or self::hl7:justifyingDetectedIssueEvent]/hl7:code[not(@xsi:type or @xsi:type='CD' or ends-with(@xsi:type,':CD'))]"
                 priority="1081"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@code or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@code))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CD: no code if null (not(@nullFlavor) or (@nullFlavor and not(@code)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CD: no displayName if null (not(@nullFlavor) or (@nullFlavor and not(@displayName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CD: no originalText on translations (not(hl7:translation/hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-CD: no null on translations (not(hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-11-CD: translation code requires codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@code or not(hl7:translation/@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-14-CD: translation displayName only if code (hl7:translation/@code or not(hl7:translation/@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="matches(@displayName,'[\r\n\t]')">
         <xsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to
        interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="code" select="@code"/>

		    <!--REPORT warning-->
<xsl:if test="@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))">
         <xsl:message>Datatype CD: waarschuwing: onbekend codeSystem '<xsl:text/>
            <xsl:value-of select="@codeSystem"/>
            <xsl:text/>' gevonden met codeSystemName 
        '<xsl:text/>
            <xsl:value-of select="./@codeSystemName"/>
            <xsl:text/>'. Bestand '<xsl:text/>
            <xsl:value-of select="concat('../vocab/',@codeSystem,'.xml')"/>
            <xsl:text/>' ontbreekt. (@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml'))) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="hl7:translation[@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))]">
         <xsl:message>Datatype CD: waarschuwing: onbekend codeSystem '<xsl:text/>
            <xsl:value-of select="hl7:translation/@codeSystem"/>
            <xsl:text/>' in translation (hl7:translation[@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="if (@codeSystem and doc-available(concat('../vocab/',@codeSystem,'.xml')) and (         document(concat('../vocab/',@codeSystem,'.xml'))/*[@codeStrength='CNE'] or         not(document(concat('../vocab/',@codeSystem,'.xml'))/*/@codeStrength))) then (          not(document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:code[@code=$code]) ) else ( 0=1 )">
         <xsl:message>Datatype CD: waarschuwing: onbekende code '<xsl:text/>
            <xsl:value-of select="$code"/>
            <xsl:text/>' gevonden in codeSystem '<xsl:text/>
            <xsl:value-of select="@codeSystem"/>
            <xsl:text/>'
        gevonden met displayName '<xsl:text/>
            <xsl:value-of select="./@displayName"/>
            <xsl:text/>'. Waarde ontbreekt in 
        '<xsl:text/>
            <xsl:value-of select="concat('../vocab/',@codeSystem,'.xml')"/>
            <xsl:text/>' (<xsl:text/>
            <xsl:value-of select="document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:name"/>
            <xsl:text/>). (if (@codeSystem and doc-available(concat('../vocab/',@codeSystem,'.xml')) and ( document(concat('../vocab/',@codeSystem,'.xml'))/*[@codeStrength='CNE'] or not(document(concat('../vocab/',@codeSystem,'.xml'))/*/@codeStrength))) then ( not(document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:code[@code=$code]) ) else ( 0=1 ) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no originalText on translations (not(hl7:translation/hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no translation on translations (not(hl7:translation/hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no null on translations (not(hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@code)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation code requires codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation codeSystemName only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation codeSystemVersion only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@code or not(hl7:translation/@displayName)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation displayName only if code (hl7:translation/@code or not(hl7:translation/@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="self::hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(../hl7:id/@root='2.16.528.1.1007.3.1') or          document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: UZI rolcode attribuut code moet een geldige RoleCodeNL bevatten (not(../hl7:id/@root='2.16.528.1.1007.3.1') or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="self::hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or not(../hl7:id/@root='2.16.528.1.1007.3.3') or          document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: organisatie rolcode attribuut code moet een geldige AssignedRoleType bevatten (@nullFlavor or not(../hl7:id/@root='2.16.528.1.1007.3.3') or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>code mag geen translation bevatten (not(hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="not(@codeSystem='2.16.840.1.113883.5.4') and not(@displayName) and not(following-sibling::hl7:value or following-sibling::hl7:text)">
         <xsl:message>Control Act: Als de code niet uit het standaard codesysteem '2.16.840.1.113883.5.4' komt is het @displayName attribuut verplicht, of er moet een value/text element zijn met aanvullende informatie (not(@codeSystem='2.16.840.1.113883.5.4') and not(@displayName) and not(following-sibling::hl7:value or following-sibling::hl7:text) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/*[self::hl7:reasonOf or self::hl7:reason]/*[self::hl7:justifiedDetectedIssue or self::hl7:justifyingDetectedIssueEvent]/hl7:value[@xsi:type='CE' or ends-with(@xsi:type,':CE')]"
                 priority="1080"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@code or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@code))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CD: no code if null (not(@nullFlavor) or (@nullFlavor and not(@code)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CD: no displayName if null (not(@nullFlavor) or (@nullFlavor and not(@displayName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CD: no originalText on translations (not(hl7:translation/hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-CD: no null on translations (not(hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-11-CD: translation code requires codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@code or not(hl7:translation/@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-14-CD: translation displayName only if code (hl7:translation/@code or not(hl7:translation/@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="matches(@displayName,'[\r\n\t]')">
         <xsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to
        interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="code" select="@code"/>

		    <!--REPORT warning-->
<xsl:if test="@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))">
         <xsl:message>Datatype CD: waarschuwing: onbekend codeSystem '<xsl:text/>
            <xsl:value-of select="@codeSystem"/>
            <xsl:text/>' gevonden met codeSystemName 
        '<xsl:text/>
            <xsl:value-of select="./@codeSystemName"/>
            <xsl:text/>'. Bestand '<xsl:text/>
            <xsl:value-of select="concat('../vocab/',@codeSystem,'.xml')"/>
            <xsl:text/>' ontbreekt. (@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml'))) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="hl7:translation[@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))]">
         <xsl:message>Datatype CD: waarschuwing: onbekend codeSystem '<xsl:text/>
            <xsl:value-of select="hl7:translation/@codeSystem"/>
            <xsl:text/>' in translation (hl7:translation[@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="if (@codeSystem and doc-available(concat('../vocab/',@codeSystem,'.xml')) and (         document(concat('../vocab/',@codeSystem,'.xml'))/*[@codeStrength='CNE'] or         not(document(concat('../vocab/',@codeSystem,'.xml'))/*/@codeStrength))) then (          not(document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:code[@code=$code]) ) else ( 0=1 )">
         <xsl:message>Datatype CD: waarschuwing: onbekende code '<xsl:text/>
            <xsl:value-of select="$code"/>
            <xsl:text/>' gevonden in codeSystem '<xsl:text/>
            <xsl:value-of select="@codeSystem"/>
            <xsl:text/>'
        gevonden met displayName '<xsl:text/>
            <xsl:value-of select="./@displayName"/>
            <xsl:text/>'. Waarde ontbreekt in 
        '<xsl:text/>
            <xsl:value-of select="concat('../vocab/',@codeSystem,'.xml')"/>
            <xsl:text/>' (<xsl:text/>
            <xsl:value-of select="document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:name"/>
            <xsl:text/>). (if (@codeSystem and doc-available(concat('../vocab/',@codeSystem,'.xml')) and ( document(concat('../vocab/',@codeSystem,'.xml'))/*[@codeStrength='CNE'] or not(document(concat('../vocab/',@codeSystem,'.xml'))/*/@codeStrength))) then ( not(document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:code[@code=$code]) ) else ( 0=1 ) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no originalText on translations (not(hl7:translation/hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no translation on translations (not(hl7:translation/hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no null on translations (not(hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@code)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation code requires codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation codeSystemName only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation codeSystemVersion only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@code or not(hl7:translation/@displayName)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation displayName only if code (hl7:translation/@code or not(hl7:translation/@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="self::hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(../hl7:id/@root='2.16.528.1.1007.3.1') or          document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: UZI rolcode attribuut code moet een geldige RoleCodeNL bevatten (not(../hl7:id/@root='2.16.528.1.1007.3.1') or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="self::hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or not(../hl7:id/@root='2.16.528.1.1007.3.3') or          document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: organisatie rolcode attribuut code moet een geldige AssignedRoleType bevatten (@nullFlavor or not(../hl7:id/@root='2.16.528.1.1007.3.3') or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CE: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/*[self::hl7:reasonOf or self::hl7:reason]/*[self::hl7:justifiedDetectedIssue or self::hl7:justifyingDetectedIssueEvent]/hl7:targetOf"
                 priority="1079"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="../hl7:code[@code and @codeSystem]"/>
         <xsl:otherwise>
            <xsl:message>Control Act: Als IssueManagement aanwezig is dan is de justifiedDetectedIssue/code verplicht (../hl7:code[@code and @codeSystem] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:subject/hl7:registrationProcess"
                 priority="1077"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@classCode) or @classCode='REG'"/>
         <xsl:otherwise>
            <xsl:message>Control Act: registrationProcess/@classCode moet indien aanwezig 'REG' zijn (not(@classCode) or @classCode='REG' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/ActClass.htm#REG)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:subject/hl7:registrationProcess/hl7:id"
                 priority="1075"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn (not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: AGB-code moet 8 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef (not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue" select="@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: @extension moet een geldige interactie-id bevatten (not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="sendingApplicationIdRoot"
                    select="../../../../hl7:sender/hl7:device/hl7:id/@root"/>
      <xsl:variable name="sendingApplicationIdExt"
                    select="../../../../hl7:sender/hl7:device/hl7:id/@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="($sendingApplicationIdRoot='2.16.840.1.113883.2.4.6.6' and $sendingApplicationIdExt='1') or @nullFlavor='UNK'"/>
         <xsl:otherwise>
            <xsl:message>Control Act: registrationProcess/id/@nullFlavor moet 'UNK' zijn als de afzender niet de ZIM is (($sendingApplicationIdRoot='2.16.840.1.113883.2.4.6.6' and $sendingApplicationIdExt='1') or @nullFlavor='UNK' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not($sendingApplicationIdRoot='2.16.840.1.113883.2.4.6.6' and $sendingApplicationIdExt='1') or @root"/>
         <xsl:otherwise>
            <xsl:message>Control Act: registrationProcess/id/@nullFlavor moet 'UNK' zijn als de afzender niet de ZIM is (not($sendingApplicationIdRoot='2.16.840.1.113883.2.4.6.6' and $sendingApplicationIdExt='1') or @root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:subject/hl7:registrationProcess/hl7:code"
                 priority="1073"
                 mode="M5">
      <xsl:variable name="codeValue" select="@code"/>
      <xsl:variable name="codeSystem" select="@codeSystem"/>
      <xsl:variable name="displayName"
                    select="document(concat('../vocab/',$codeSystem,'.xml'))/*/hl7:code[@code=$codeValue]/@displayName"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="$codeSystem='2.16.840.1.113883.2.4.15.4' or $codeSystem='2.16.840.1.113883.6.1'"/>
         <xsl:otherwise>
            <xsl:message>Control Act: registrationProcess/code moet uit ActRegistrycodeNL (2.16.840.1.113883.2.4.15.4) of LOINC (2.16.840.1.113883.6.1) komen. ($codeSystem='2.16.840.1.113883.2.4.15.4' or $codeSystem='2.16.840.1.113883.6.1' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="document(concat('../vocab/',$codeSystem,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Control Act: registrationProcess/code '<xsl:text/>
               <xsl:value-of select="$codeValue"/>
               <xsl:text/>' is niet geldig binnen codeSystem '<xsl:text/>
               <xsl:value-of select="$codeSystem"/>
               <xsl:text/>' (ActRegistryCodeNL of LOINC). (document(concat('../vocab/',$codeSystem,'.xml'))/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($codeValue='117117' or $codeValue='118118' or $codeValue='118400' or $codeValue='603508' or $codeValue='302850') then (                 ../hl7:subject1) else (../hl7:subject2)"/>
         <xsl:otherwise>
            <xsl:message>Control Act: registrationProcess/code '<xsl:text/>
               <xsl:value-of select="$codeValue"/>
               <xsl:text/>' (<xsl:text/>
               <xsl:value-of select="$displayName"/>
               <xsl:text/>) komt niet overeen met het gebruikte type register. Rollen
            horen in subject1 en Act's in subject2. (if ($codeValue='117117' or $codeValue='118118' or $codeValue='118400' or $codeValue='603508' or $codeValue='302850') then ( ../hl7:subject1) else (../hl7:subject2) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:subject/hl7:registrationProcess/hl7:statusCode"
                 priority="1071"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CS: @code/@typeCode and @nullFlavor are mutually exclusive ((@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystem)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CS: cannot have codeSystem (not(@codeSystem) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CS: cannot have codeSystemName (not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CS: cannot have codeSystemVersion (not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CS: cannot have displayName (not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CS: cannot have originalText (not(hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CS: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CS: cannot have translation (not(hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:subject/hl7:registrationProcess/hl7:effectiveTime"
                 priority="1069"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-QTY: no uncertainty (not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-QTY: no history or updateMode (count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@nullFlavor and not(@value|@unit|*)) or (not(@nullFlavor) and (@value|@unit|hl7:low|hl7:center|hl7:high|hl7:width))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-IVL: null violation. Cannot have @nullFlavor and @value or child elements, or the other way around ((@nullFlavor and not(@value|@unit|*)) or (not(@nullFlavor) and (@value|@unit|hl7:low|hl7:center|hl7:high|hl7:width)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(*[@nullFlavor and (@value|@unit)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-IVL: null violation. Cannot have @nullFlavor and @value on any child elements (not(*[@nullFlavor and (@value|@unit)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:*[@nullFlavor and (@value|@unit)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-IVL: null violation. Child element has @nullFlavor and @value (not(hl7:*[@nullFlavor and (@value|@unit)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="         @nullFlavor or         (not(@nullFlavor) and @value and not(*)) or         (not(@nullFlavor) and not(@value) and (hl7:low|hl7:center|hl7:high|hl7:width)) or         (not(@nullFlavor) and not(@value) and (hl7:*[not(@nullFlavor)])) or         (not(@nullFlavor) and not(@value) and hl7:center and not(hl7:low|hl7:high|hl7:width)) or         (not(@nullFlavor) and not(@value) and not(hl7:center) and hl7:width and not(hl7:low and hl7:high))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-IVL: co-occurence violation. Cannot have @value and other child elements, or missing @value and child elements with data, or center element with other elements, or width element with
        both low and high elements (@nullFlavor or (not(@nullFlavor) and @value and not(*)) or (not(@nullFlavor) and not(@value) and (hl7:low|hl7:center|hl7:high|hl7:width)) or (not(@nullFlavor) and not(@value) and (hl7:*[not(@nullFlavor)])) or (not(@nullFlavor) and not(@value) and hl7:center and not(hl7:low|hl7:high|hl7:width)) or (not(@nullFlavor) and not(@value) and not(hl7:center) and hl7:width and not(hl7:low and hl7:high)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(*[@updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-IVL: no updateMode on IVL attributes (count(*[@updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:low/@value and hl7:high/@value) or hl7:low/@value != hl7:high/@value"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-IVL: low/@value must not be equal to high/@value (not(hl7:low/@value and hl7:high/@value) or hl7:low/@value != hl7:high/@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:width) or         hl7:width[not(@unit)] or         hl7:width[@value and @unit]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-PQR: width element: no unit without value (not(hl7:width) or hl7:width[not(@unit)] or hl7:width[@value and @unit] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:width/hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-PQR: width element: no translation (not(hl7:width/hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:low/@value and hl7:high/@value) or string-length(hl7:low/@value) = string-length(hl7:high/@value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-IVL_TS: low/@value must have the same precision as
        high/@value (not(hl7:low/@value and hl7:high/@value) or string-length(hl7:low/@value) = string-length(hl7:high/@value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:low/@value and hl7:high/@value) or         number(substring(concat(hl7:low/@value,'00000000000000'),1,14)) &lt; number(substring(concat(hl7:high/@value,'00000000000000'),1,14))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-IVL_TS: low/@value must be before high/@value (not(hl7:low/@value and hl7:high/@value) or number(substring(concat(hl7:low/@value,'00000000000000'),1,14)) &lt; number(substring(concat(hl7:high/@value,'00000000000000'),1,14)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="tum" select="'^(us|ms|s|min|h|d|wk|mo|a|)$'"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="matches(hl7:width/@unit, $tum)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-IVL_TS: for width only us (microseconds), ms (milliseconds), s (seconds), min (minute), h (hours), d (day), wk (week),
        mo (month) or a (year) are allowed (matches(hl7:width/@unit, $tum) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or @nullFlavor='UNK'"/>
         <xsl:otherwise>
            <xsl:message>Control Act: registrationProcess/effectiveTime/@nullFlavor moet, indien aanwezig, 'UNK' zijn. (not(@nullFlavor) or @nullFlavor='UNK' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:*/@nullFlavor) or hl7:*/@nullFlavor='UNK'"/>
         <xsl:otherwise>
            <xsl:message>Control Act: registrationProcess/effectiveTime/<xsl:text/>
               <xsl:value-of select="local-name()"/>
               <xsl:text/>/@nullFlavor moet, indien aanwezig, 'UNK' zijn. (not(hl7:*/@nullFlavor) or hl7:*/@nullFlavor='UNK' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or hl7:*[local-name()='low' or local-name()='high']"/>
         <xsl:otherwise>
            <xsl:message>Control Act: registrationProcess/effectiveTime mag alleen bestaan uit datum eerste aanmelding (effectiveTime/low) en een einde van de geldigheidsperiode (effectiveTime/high). (@nullFlavor or hl7:*[local-name()='low' or local-name()='high'] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:queryByParameter"
                 priority="1067"
                 mode="M5">
      <xsl:variable name="interactionId" select="local-name(../..)"/>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="hl7:executionAndDeliveryTime or             $interactionId='PRPA_IN900111NL' or              $interactionId='PRPA_IN900112NL' or             $interactionId='QUMT_IN020010' or             $interactionId='QUMT_IN020011NL' or             $interactionId='QUMT_IN020011NL02' or             $interactionId='QUMT_IN900008NL' or             $interactionId='QUMT_IN900013NL' or             $interactionId='QUPA_IN101101' or              $interactionId='QUPA_IN101102' or             $interactionId='QUPA_IN101103' or              $interactionId='QUPA_IN101104'"/>
         <xsl:otherwise>
            <xsl:message>Control Act: Waarschuwing: queryByParameter/executionAndDeliveryTime is verplicht vanaf AORTA 6 indien hier een waarde voor is ingesteld in het XIS. (hl7:executionAndDeliveryTime or $interactionId='PRPA_IN900111NL' or $interactionId='PRPA_IN900112NL' or $interactionId='QUMT_IN020010' or $interactionId='QUMT_IN020011NL' or $interactionId='QUMT_IN020011NL02' or $interactionId='QUMT_IN900008NL' or $interactionId='QUMT_IN900013NL' or $interactionId='QUPA_IN101101' or $interactionId='QUPA_IN101102' or $interactionId='QUPA_IN101103' or $interactionId='QUPA_IN101104' / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:responsePriorityCode or $interactionId='PRPA_IN900111NL' or $interactionId='PRPA_IN900112NL'"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryByParameter/responsePriorityCode is verplicht vanaf AORTA 6 (hl7:responsePriorityCode or $interactionId='PRPA_IN900111NL' or $interactionId='PRPA_IN900112NL' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:responseModalityCode or $interactionId='PRPA_IN900111NL' or $interactionId='PRPA_IN900112NL'"/>
         <xsl:otherwise>
            <xsl:message>Control Act: responseModalityCode is verplicht vanaf AORTA 6 (hl7:responseModalityCode or $interactionId='PRPA_IN900111NL' or $interactionId='PRPA_IN900112NL' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:statusCode"
                 priority="1066"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CS: @code/@typeCode and @nullFlavor are mutually exclusive ((@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystem)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CS: cannot have codeSystem (not(@codeSystem) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CS: cannot have codeSystemName (not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CS: cannot have codeSystemVersion (not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CS: cannot have displayName (not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CS: cannot have originalText (not(hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CS: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CS: cannot have translation (not(hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="interactionId" select="local-name(../../..)"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@code='executing' or @code='aborted' or @code='waitContinuedQueryResponse'"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryByParameter/statusCode moet 'executing', 'aborted', of 'waitContinuedQueryResponse' zijn (@code='executing' or @code='aborted' or @code='waitContinuedQueryResponse' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@code='executing' or             $interactionId='QUQI_IN000003' or             $interactionId='QUQI_IN000003UV'"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryByParameter/statusCode moet 'executing' zijn, behalve bij QUQI_IN000003(UV) (@code='executing' or $interactionId='QUQI_IN000003' or $interactionId='QUQI_IN000003UV' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@code='aborted' or @code='waitContinuedQueryResponse' or not(              $interactionId='QUQI_IN000003' or             $interactionId='QUQI_IN000003UV')"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryByParameter/statusCode moet 'aborted' of 'waitContinuedQueryResponse' zijn bij QUQI_IN000003(UV) (@code='aborted' or @code='waitContinuedQueryResponse' or not( $interactionId='QUQI_IN000003' or $interactionId='QUQI_IN000003UV') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:modifyCode"
                 priority="1065"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CS: @code/@typeCode and @nullFlavor are mutually exclusive ((@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystem)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CS: cannot have codeSystem (not(@codeSystem) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CS: cannot have codeSystemName (not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CS: cannot have codeSystemVersion (not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CS: cannot have displayName (not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CS: cannot have originalText (not(hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CS: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CS: cannot have translation (not(hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@code='M' or @code='N'"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryByParameter/modifyCode moet 'M' (Modified) of 'N' (New) zijn (@code='M' or @code='N' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:responseElementGroupId"
                 priority="1064"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn (not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: AGB-code moet 8 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef (not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue" select="@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: @extension moet een geldige interactie-id bevatten (not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryByParameter/responseElementGroupId mag niet gebruikt worden (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:responseModalityCode"
                 priority="1063"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CS: @code/@typeCode and @nullFlavor are mutually exclusive ((@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystem)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CS: cannot have codeSystem (not(@codeSystem) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CS: cannot have codeSystemName (not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CS: cannot have codeSystemVersion (not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CS: cannot have displayName (not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CS: cannot have originalText (not(hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CS: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CS: cannot have translation (not(hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@code='R' or @code='B'"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryByParameter/responseModalityCode moet 'R' (Realtime) of 'B' (Batch) zijn (@code='R' or @code='B' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="interactionId" select="local-name(../../..)"/>
      <xsl:variable name="interactionVocab" select="'../vocab/2.16.840.1.113883.1.6.xml'"/>
      <xsl:variable name="interactionSendType"
                    select="document($interactionVocab)/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='Verzendtype']/@value"/>
      <xsl:variable name="interactionQueryType"
                    select="document($interactionVocab)/*/hl7:code[@code=$interactionId]/hl7:qualifier[@name='Vraagtype']/@value"/>
      <xsl:variable name="receivingApplication"
                    select="../../../hl7:receiver/hl7:device/hl7:id[@root='2.16.840.1.113883.2.4.6.6']/@extension"/>
      <xsl:variable name="sendingApplication"
                    select="../../../hl7:sender/hl7:device/hl7:id[@root='2.16.840.1.113883.2.4.6.6']/@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@code='R') or not($interactionSendType='Initiërend') or $interactionQueryType='Direct' or $sendingApplication='1'"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryByParameter/responseModalityCode/@code moet 'B' zijn bij indirecte vragen aan de ZIM (not(@code='R') or not($interactionSendType='Initiërend') or $interactionQueryType='Direct' or $sendingApplication='1' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@code='B') or ($interactionQueryType='Indirect' and not($sendingApplication='1'))"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryByParameter/responseModalityCode/@code moet 'R' zijn bij directe vragen en bij vragen verstuurd door de ZIM (in feite ook een directe vraag) (not(@code='B') or ($interactionQueryType='Indirect' and not($sendingApplication='1')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:responsePriorityCode"
                 priority="1062"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CS: @code/@typeCode and @nullFlavor are mutually exclusive ((@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystem)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CS: cannot have codeSystem (not(@codeSystem) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CS: cannot have codeSystemName (not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CS: cannot have codeSystemVersion (not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CS: cannot have displayName (not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CS: cannot have originalText (not(hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CS: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CS: cannot have translation (not(hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@code='I'"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryByParameter/responsePriorityCode moet 'I' (Immediate) zijn (@code='I' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:initialQuantity"
                 priority="1061"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-QTY: no uncertainty (not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-QTY: no history or updateMode (count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@nullFlavor or @value or *) and not(@nullFlavor and @value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-INT: null or value or child element in case of extension ((@nullFlavor or @value or *) and not(@nullFlavor and @value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:uncertainty)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-INT: no uncertainty (not(hl7:uncertainty) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryByParameter/initialQuantity mag niet gebruikt worden (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="../hl7:initialQuantityCode"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryByParameter/initialQuantityCode is verplicht indien initialQuantity wordt gebruikt (../hl7:initialQuantityCode / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:initialQuantityCode"
                 priority="1060"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@code or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@code))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CD: no code if null (not(@nullFlavor) or (@nullFlavor and not(@code)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CD: no displayName if null (not(@nullFlavor) or (@nullFlavor and not(@displayName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CD: no originalText on translations (not(hl7:translation/hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-CD: no null on translations (not(hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-11-CD: translation code requires codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@code or not(hl7:translation/@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-14-CD: translation displayName only if code (hl7:translation/@code or not(hl7:translation/@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="matches(@displayName,'[\r\n\t]')">
         <xsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to
        interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="code" select="@code"/>

		    <!--REPORT warning-->
<xsl:if test="@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))">
         <xsl:message>Datatype CD: waarschuwing: onbekend codeSystem '<xsl:text/>
            <xsl:value-of select="@codeSystem"/>
            <xsl:text/>' gevonden met codeSystemName 
        '<xsl:text/>
            <xsl:value-of select="./@codeSystemName"/>
            <xsl:text/>'. Bestand '<xsl:text/>
            <xsl:value-of select="concat('../vocab/',@codeSystem,'.xml')"/>
            <xsl:text/>' ontbreekt. (@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml'))) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="hl7:translation[@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))]">
         <xsl:message>Datatype CD: waarschuwing: onbekend codeSystem '<xsl:text/>
            <xsl:value-of select="hl7:translation/@codeSystem"/>
            <xsl:text/>' in translation (hl7:translation[@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="if (@codeSystem and doc-available(concat('../vocab/',@codeSystem,'.xml')) and (         document(concat('../vocab/',@codeSystem,'.xml'))/*[@codeStrength='CNE'] or         not(document(concat('../vocab/',@codeSystem,'.xml'))/*/@codeStrength))) then (          not(document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:code[@code=$code]) ) else ( 0=1 )">
         <xsl:message>Datatype CD: waarschuwing: onbekende code '<xsl:text/>
            <xsl:value-of select="$code"/>
            <xsl:text/>' gevonden in codeSystem '<xsl:text/>
            <xsl:value-of select="@codeSystem"/>
            <xsl:text/>'
        gevonden met displayName '<xsl:text/>
            <xsl:value-of select="./@displayName"/>
            <xsl:text/>'. Waarde ontbreekt in 
        '<xsl:text/>
            <xsl:value-of select="concat('../vocab/',@codeSystem,'.xml')"/>
            <xsl:text/>' (<xsl:text/>
            <xsl:value-of select="document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:name"/>
            <xsl:text/>). (if (@codeSystem and doc-available(concat('../vocab/',@codeSystem,'.xml')) and ( document(concat('../vocab/',@codeSystem,'.xml'))/*[@codeStrength='CNE'] or not(document(concat('../vocab/',@codeSystem,'.xml'))/*/@codeStrength))) then ( not(document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:code[@code=$code]) ) else ( 0=1 ) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no originalText on translations (not(hl7:translation/hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no translation on translations (not(hl7:translation/hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no null on translations (not(hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@code)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation code requires codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation codeSystemName only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation codeSystemVersion only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@code or not(hl7:translation/@displayName)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation displayName only if code (hl7:translation/@code or not(hl7:translation/@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="self::hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(../hl7:id/@root='2.16.528.1.1007.3.1') or          document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: UZI rolcode attribuut code moet een geldige RoleCodeNL bevatten (not(../hl7:id/@root='2.16.528.1.1007.3.1') or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="self::hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or not(../hl7:id/@root='2.16.528.1.1007.3.3') or          document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: organisatie rolcode attribuut code moet een geldige AssignedRoleType bevatten (@nullFlavor or not(../hl7:id/@root='2.16.528.1.1007.3.3') or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CE: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="../hl7:initialQuantity"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryByParameter/initialQuantity is verplicht indien initialQuantityCode wordt gebruikt (../hl7:initialQuantity / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:executionAndDeliveryTime"
                 priority="1059"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-QTY: no uncertainty (not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-QTY: no history or updateMode (count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@nullFlavor or @value or *) and not(@nullFlavor and @value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-TS: null or value or child element in case of extension ((@nullFlavor or @value or *) and not(@nullFlavor and @value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(../../../hl7:profileId[@root='2.16.840.1.113883.2.4.3.11.1' and (@extension='608' or @extension='705' or @extension='805')])"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryByParameter/executionAndDeliveryTime is pas toegestaan vanaf profileId 810 (not(../../../hl7:profileId[@root='2.16.840.1.113883.2.4.3.11.1' and (@extension='608' or @extension='705' or @extension='805')]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryByParameter/executionAndDeliveryTime/@value moet een waarde hebben (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="matches(@value,'^[0-9]{12}')"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryByParameter/executionAndDeliveryTime/@value moet tenminste tot op de minuten nauwkeurig zijn (matches(@value,'^[0-9]{12}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="creationTime" select="../../../hl7:creationTime/@value"/>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@value)=string-length($creationTime))">
         <xsl:message>Control Act: queryByParameter/executionAndDeliveryTime/@value '<xsl:text/>
            <xsl:value-of select="@value"/>
            <xsl:text/>' en creationTime '<xsl:text/>
            <xsl:value-of select="$creationTime"/>
            <xsl:text/>' hebben niet dezelfde precisie. Aanbevolen is om ze dezelfde precisie te geven (not(string-length(@value)=string-length($creationTime)) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ((string-length(@value)=14 and string-length($creationTime)=14) or             (string-length(@value)=12 and string-length($creationTime)=12)) then (             (number(@value) - number($creationTime)) &gt;= 5) else ( 1=1 )"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryByParameter/executionAndDeliveryTime/@value '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' ligt niet 5 seconden of meer na creationTime '<xsl:text/>
               <xsl:value-of select="$creationTime"/>
               <xsl:text/>' (if ((string-length(@value)=14 and string-length($creationTime)=14) or (string-length(@value)=12 and string-length($creationTime)=12)) then ( (number(@value) - number($creationTime)) &gt;= 5) else ( 1=1 ) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:queryByParameter//hl7:semanticsText"
                 priority="1058"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or count(*)&gt;0  or text()[string-length(normalize-space())&gt;0]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-BIN: there must be a nullFlavor, or content must be non-empty (@nullFlavor or count(*)&gt;0 or text()[string-length(normalize-space())&gt;0] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@integrityCheck) or @integrityCheckAlgorithm"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-ED: integrityCheckAlgorithm required if integrityCheck (not(@integrityCheck) or @integrityCheckAlgorithm / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-ED: thumbnails not null and reference (not(hl7:thumbnail) or hl7:thumbnail[not(@nullFlavor and hl7:reference)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-ED: thumbnails do not have thumbnails (not(hl7:thumbnail) or hl7:thumbnail[not(hl7:thumbnail)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-ED: compression only on binary ((@compression and (hl7:reference/@value or (@representation='B64' and text()))) or not(@compression) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain'))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-ED: value implies mediaType is text/plain (not(@value) or (@value and (not(@mediaType) or @mediaType='text/plain')) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-ED: no history or updateMode (count(*[self::hl7:reference or self::hl7:thumbnail][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@value or xml) or not(@charset)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-ED: no charset for value or xml (not(@value or xml) or not(@charset) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-9-ED: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@mediaType))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-ED: no mediaType if null (not(@nullFlavor) or (@nullFlavor and not(@mediaType)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@charset))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-11-ED: no charset if null (not(@nullFlavor) or (@nullFlavor and not(@charset)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@language))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-ED: no language if null (not(@nullFlavor) or (@nullFlavor and not(@language)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@compression))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-ED: no compression if null (not(@nullFlavor) or (@nullFlavor and not(@compression)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@integrityCheck))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-14-ED: no integrityCheck if null (not(@nullFlavor) or (@nullFlavor and not(@integrityCheck)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@integrityCheckAlgorithm))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-15-ED: no integrityCheckAlgorithm if null (not(@nullFlavor) or (@nullFlavor and not(@integrityCheckAlgorithm)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-16-ED: no thumbnail if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:thumbnail/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(hl7:translation))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-17-ED: no translation if null (not(@nullFlavor) or (@nullFlavor and not(hl7:translation)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="mediaType" select="@mediaType"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@mediaType) or document('../vocab/ED-mediaType.xml')/*/hl7:code[@code=$mediaType]"/>
         <xsl:otherwise>
            <xsl:message>Datatype ED: unsupported mediaType value
        '<xsl:text/>
               <xsl:value-of select="$mediaType"/>
               <xsl:text/>' (not(@mediaType) or document('../vocab/ED-mediaType.xml')/*/hl7:code[@code=$mediaType] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(thumbnail)"/>
         <xsl:otherwise>
            <xsl:message>Datatype ED: thumbnail is in Nederland vooralsnog niet toegestaan (not(thumbnail) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation) or hl7:thumbnail[not(hl7:translation)]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ST: no nested translations (not(hl7:translation) or hl7:thumbnail[not(hl7:translation)] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <xsl:message>Control Act: het queryParameter element semanticsText bij voorkeur niet gebruiken (false() / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:queryByParameter/hl7:sortControl"
                 priority="1057"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryByParameter/sortControl mag niet gebruikt worden (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:queryAck"
                 priority="1055"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:resultTotalQuantity"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryAck/resultTotalQuantity ontbreekt (hl7:resultTotalQuantity / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:resultCurrentQuantity"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryAck/resultCurrentQuantity ontbreekt (hl7:resultCurrentQuantity / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:resultRemainingQuantity"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryAck/resultRemainingQuantity ontbreekt (hl7:resultRemainingQuantity / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:queryAck/hl7:id"
                 priority="1054"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn (not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: AGB-code moet 8 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef (not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue" select="@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: @extension moet een geldige interactie-id bevatten (not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@root and @extension"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryAck/queryId mist root en/of extension (@root and @extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:queryAck/hl7:statusCode"
                 priority="1053"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CS: @code/@typeCode and @nullFlavor are mutually exclusive ((@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystem)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CS: cannot have codeSystem (not(@codeSystem) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CS: cannot have codeSystemName (not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CS: cannot have codeSystemVersion (not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CS: cannot have displayName (not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CS: cannot have originalText (not(hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CS: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CS: cannot have translation (not(hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="interactionId" select="local-name(../../..)"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@code='aborted' or @code='deliveredResponse'"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryAck/statusCode moet 'aborted', of 'deliveredResponse' zijn (@code='aborted' or @code='deliveredResponse' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:queryAck/hl7:queryResponseCode"
                 priority="1052"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CS: @code/@typeCode and @nullFlavor are mutually exclusive ((@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystem)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CS: cannot have codeSystem (not(@codeSystem) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CS: cannot have codeSystemName (not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CS: cannot have codeSystemVersion (not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CS: cannot have displayName (not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CS: cannot have originalText (not(hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CS: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CS: cannot have translation (not(hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@code='NF' or @code='AE' or @code='QE' or @code='OK'"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryAck/queryResponsecode/code moet NF (Nothing found), AE (Application Error), QE (Query error) of OK bevatten (@code='NF' or @code='AE' or @code='QE' or @code='OK' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="acknowledgementTypeCode" select="../../../hl7:acknowledgement/@typeCode"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($acknowledgementTypeCode='AA') then (             @code='NF' or @code='OK' ) else (             @code='AE' or @code='QE'             )"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryAck/queryResponseCode moet bij een positief antwoord 'OK' of 'NF' zijn, anders moet deze 'AE' of 'QE' zijn (if ($acknowledgementTypeCode='AA') then ( @code='NF' or @code='OK' ) else ( @code='AE' or @code='QE' ) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="resultCurrentQuantity" select="../hl7:resultCurrentQuantity/@value"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@code='OK') or ($acknowledgementTypeCode='AA' and $resultCurrentQuantity &gt; 0)"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryAck/queryResponseCode moet 'OK' bevatten indien er op basis van de queryParameters resultaten gevonden konden 
            worden (resultCurrentQuantity/@value='<xsl:text/>
               <xsl:value-of select="$resultCurrentQuantity"/>
               <xsl:text/>') en de query valide
            is (acknowledgement/@typeCode='<xsl:text/>
               <xsl:value-of select="$acknowledgementTypeCode"/>
               <xsl:text/>') (not(@code='OK') or ($acknowledgementTypeCode='AA' and $resultCurrentQuantity &gt; 0) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@code='NF') or ($acknowledgementTypeCode='AA' and $resultCurrentQuantity = 0)"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryAck/queryResponseCode moet 'NF' bevatten indien er op basis van de queryParameters geen resultaten gevonden konden 
            worden (resultCurrentQuantity/@value='<xsl:text/>
               <xsl:value-of select="$resultCurrentQuantity"/>
               <xsl:text/>') en de query valide
            is (acknowledgement/@typeCode='<xsl:text/>
               <xsl:value-of select="$acknowledgementTypeCode"/>
               <xsl:text/>') (not(@code='NF') or ($acknowledgementTypeCode='AA' and $resultCurrentQuantity = 0) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:queryAck/hl7:resultTotalQuantity"
                 priority="1051"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-QTY: no uncertainty (not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-QTY: no history or updateMode (count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@nullFlavor or @value or *) and not(@nullFlavor and @value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-INT: null or value or child element in case of extension ((@nullFlavor or @value or *) and not(@nullFlavor and @value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:uncertainty)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-INT: no uncertainty (not(hl7:uncertainty) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="number(@value) &gt;= 0 or @nullFlavor='NAV'"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryAck/resultTotalQuantity moet 0 of groter zijn, of nullFlavor moet 'NAV' zijn (number(@value) &gt;= 0 or @nullFlavor='NAV' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="resultCurrentQuantity"
                    select="number(../hl7:resultCurrentQuantity/@value)"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if (@value and $resultCurrentQuantity) then (number(@value) &gt;= $resultCurrentQuantity) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryAck/resultTotalQuantity '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' moet groter zijn dan resultCurrentQuantity '<xsl:text/>
               <xsl:value-of select="$resultCurrentQuantity"/>
               <xsl:text/>' (if (@value and $resultCurrentQuantity) then (number(@value) &gt;= $resultCurrentQuantity) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:queryAck/hl7:resultCurrentQuantity"
                 priority="1050"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-QTY: no uncertainty (not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-QTY: no history or updateMode (count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@nullFlavor or @value or *) and not(@nullFlavor and @value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-INT: null or value or child element in case of extension ((@nullFlavor or @value or *) and not(@nullFlavor and @value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:uncertainty)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-INT: no uncertainty (not(hl7:uncertainty) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) and @value"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryAck/resultCurrentQuantity moet 0 of groter zijn (not(@nullFlavor) and @value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="resultCurrentQuantity" select="count(../../hl7:subject)"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value=$resultCurrentQuantity"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryAck/resultCurrentQuantity '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' moet gelijk zijn aan het aantal subject elementen ('<xsl:text/>
               <xsl:value-of select="$resultCurrentQuantity"/>
               <xsl:text/>') (@value=$resultCurrentQuantity / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:queryAck/hl7:resultRemainingQuantity"
                 priority="1049"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-QTY: no uncertainty (not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-QTY: no history or updateMode (count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@nullFlavor or @value or *) and not(@nullFlavor and @value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-INT: null or value or child element in case of extension ((@nullFlavor or @value or *) and not(@nullFlavor and @value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:uncertainty)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-INT: no uncertainty (not(hl7:uncertainty) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor='NAV' or @value &gt;= 0"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryAck/resultRemainingQuantity moet 0 of groter zijn, of nullFlavor moet 'NAV' zijn (@nullFlavor='NAV' or @value &gt;= 0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="resultTotalQuantity" select="number(../hl7:resultTotalQuantity/@value)"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if (@value and $resultTotalQuantity) then (number(@value) &lt;= $resultTotalQuantity) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Control Act: queryAck/resultRemainingQuantity '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' moet kleiner dan of gelijk aan resultTotalQuantity '<xsl:text/>
               <xsl:value-of select="$resultTotalQuantity"/>
               <xsl:text/>' zijn (if (@value and $resultTotalQuantity) then (number(@value) &lt;= $resultTotalQuantity) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:informationRecipient"
                 priority="1047"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>Control Act: informationRecipient mag (nog) niet gebruikt worden (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:dataEnterer"
                 priority="1045"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>Control Act: dataEnterer mag (nog) niet gebruikt worden (not(.) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:authorOrPerformer"
                 priority="1043"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@typeCode='AUT' or @typeCode='PRF'"/>
         <xsl:otherwise>
            <xsl:message>Control Act: authorOrPerformer/@typeCode moet AUT or PRF zijn (@typeCode='AUT' or @typeCode='PRF' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant/hl7:AssignedPerson"
                 priority="1041"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(hl7:id[@root='2.16.528.1.1007.3.1' or @root='2.16.840.1.113883.2.4.6.3' or @root='2.16.840.1.113883.2.4.3.11.7.3' or @root='2.16.528.1.1003.1.3.5.4.1'])&gt;=1"/>
         <xsl:otherwise>
            <xsl:message>Control Act: authorOrPerformer/*/AssignedPerson/id. Tenminste één id moet als root 2.16.528.1.1007.3.1 (UZI), 2.16.840.1.113883.2.4.6.3 (BSN) of 2.16.840.1.113883.2.4.3.11.7.3 (batch inzage auteur), of 2.16.528.1.1003.1.3.5.4.1 (Nictiz-klantenloket met PKIO-pas van Getronics) hebben (count(hl7:id[@root='2.16.528.1.1007.3.1' or @root='2.16.840.1.113883.2.4.6.3' or @root='2.16.840.1.113883.2.4.3.11.7.3' or @root='2.16.528.1.1003.1.3.5.4.1'])&gt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="not(hl7:id[@root='2.16.528.1.1007.3.1']) or hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']"/>
         <xsl:otherwise>
            <xsl:message>Control Act: authorOrPerformer/*/AssignedPerson/code ontbreekt. Dit is alleen toegestaan als de rolcode 00.000 is. (not(hl7:id[@root='2.16.528.1.1007.3.1']) or hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111'] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:id[@root='2.16.528.1.1007.3.1']) or hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3' and @extension]"/>
         <xsl:otherwise>
            <xsl:message>Control Act: authorOrPerformer/*/AssignedPerson/Organization/id moet de zorgaanbieder van de persoon identificeren (not(hl7:id[@root='2.16.528.1.1007.3.1']) or hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3' and @extension] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:id[@root='2.16.840.1.113883.2.4.6.3']) or hl7:Organization/hl7:id[@root='2.16.840.1.113883.2.4.3.11.25']"/>
         <xsl:otherwise>
            <xsl:message>Control Act: authorOrPerformer/*/AssignedPerson/Organization/id/@root moet '2.16.840.1.113883.2.4.3.11.25' bevatten (not(hl7:id[@root='2.16.840.1.113883.2.4.6.3']) or hl7:Organization/hl7:id[@root='2.16.840.1.113883.2.4.3.11.25'] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:id[@root='2.16.840.1.113883.2.4.3.11' or @root='2.16.528.1.1003.1.3.5.4.1']) or hl7:Organization/hl7:id[@root='2.16.840.1.113883.2.4.3.11' and @extension='7']"/>
         <xsl:otherwise>
            <xsl:message>Control Act: authorOrPerformer/*/AssignedPerson/Organization/id moet de Nictiz-klantenloket organisatie identificeren (not(hl7:id[@root='2.16.840.1.113883.2.4.3.11' or @root='2.16.528.1.1003.1.3.5.4.1']) or hl7:Organization/hl7:id[@root='2.16.840.1.113883.2.4.3.11' and @extension='7'] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3']) or hl7:Organization/hl7:name"/>
         <xsl:otherwise>
            <xsl:message>Control Act: authorOrPerformer/*/AssignedPerson/Organization/name moet de zorgaanbieder/organisatienaam bevatten (not(hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3']) or hl7:Organization/hl7:name / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:Organization/hl7:id[@root='2.16.840.1.113883.2.4.3.11' and @extension='7']) or hl7:Organization/hl7:name"/>
         <xsl:otherwise>
            <xsl:message>Control Act: authorOrPerformer/*/AssignedPerson/Organization/name moet de Nictiz-klantenloket organisatienaam bevatten (not(hl7:Organization/hl7:id[@root='2.16.840.1.113883.2.4.3.11' and @extension='7']) or hl7:Organization/hl7:name / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant/hl7:AssignedPerson/hl7:id"
                 priority="1039"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn (not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: AGB-code moet 8 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef (not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue" select="@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: @extension moet een geldige interactie-id bevatten (not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@root='2.16.528.1.1007.3.1' or @root='2.16.840.1.113883.2.4.6.3' or @root='2.16.840.1.113883.2.4.3.11.7.3' or @root='2.16.528.1.1003.1.3.5.4.1' or @root='2.16.840.1.113883.2.4.6.1'"/>
         <xsl:otherwise>
            <xsl:message>Control Act: authorOrPerformer/*/AssignedPerson/id. @root moet 2.16.528.1.1007.3.1 (UZI), 2.16.840.1.113883.2.4.6.3 (BSN) of 2.16.840.1.113883.2.4.3.11.7.3 (batch inzage auteur), 2.16.528.1.1003.1.3.5.4.1 (Nictiz-klantenloket met PKIO-pas van Getronics), of 2.16.840.1.113883.2.4.6.1 (AGB-code) zijn (@root='2.16.528.1.1007.3.1' or @root='2.16.840.1.113883.2.4.6.3' or @root='2.16.840.1.113883.2.4.3.11.7.3' or @root='2.16.528.1.1003.1.3.5.4.1' or @root='2.16.840.1.113883.2.4.6.1' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or following-sibling::hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.8'][@code='P']"/>
         <xsl:otherwise>
            <xsl:message>Control Act: authorOrPerformer/*/AssignedPerson/code/@code moet "P" (Patiënt) zijn. Wettelijke vertegenwoordigers moet dit via het Klantenloket doen en kunnen dus niet als auteur optreden (not(@root='2.16.840.1.113883.2.4.6.3') or following-sibling::hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.8'][@code='P'] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or              not(../../../../*[local-name()='queryByParameter' or local-name()='subject']//hl7:*[@root='2.16.840.1.113883.2.4.6.3']) or              ../../../../../hl7:attentionLine"/>
         <xsl:otherwise>
            <xsl:message>Control Act: patiëntgebonden interacties, verzonden vanuit een patiëntenportaal (GBP), moeten een attentionLine hebben (not(@root='2.16.840.1.113883.2.4.6.3') or not(../../../../*[local-name()='queryByParameter' or local-name()='subject']//hl7:*[@root='2.16.840.1.113883.2.4.6.3']) or ../../../../../hl7:attentionLine / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.3.11.7.3' or @root='2.16.528.1.1003.1.3.5.4.1') or following-sibling::hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.8'][@code='KLANTENLOKET']"/>
         <xsl:otherwise>
            <xsl:message>Control Act: authorOrPerformer/*/AssignedPerson/code/@code moet "KLANTENLOKET" zijn voor klantenloketmedewerkers (not(@root='2.16.840.1.113883.2.4.3.11.7.3' or @root='2.16.528.1.1003.1.3.5.4.1') or following-sibling::hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.8'][@code='KLANTENLOKET'] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.3.11.7.3' or @root='2.16.528.1.1003.1.3.5.4.1') or              not(../../../../*[local-name()='queryByParameter' or local-name()='subject']//hl7:*[@root='2.16.840.1.113883.2.4.6.3']) or              ../../../../../hl7:attentionLine"/>
         <xsl:otherwise>
            <xsl:message>Control Act: patiëntgebonden interacties, verzonden vanuit het klantenloket (GBK), moeten een attentionLine hebben (not(@root='2.16.840.1.113883.2.4.3.11.7.3' or @root='2.16.528.1.1003.1.3.5.4.1') or not(../../../../*[local-name()='queryByParameter' or local-name()='subject']//hl7:*[@root='2.16.840.1.113883.2.4.6.3']) or ../../../../../hl7:attentionLine / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant/hl7:AssignedPerson/hl7:code"
                 priority="1038"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@code or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@code))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CD: no code if null (not(@nullFlavor) or (@nullFlavor and not(@code)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CD: no displayName if null (not(@nullFlavor) or (@nullFlavor and not(@displayName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CD: no originalText on translations (not(hl7:translation/hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-CD: no null on translations (not(hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-11-CD: translation code requires codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@code or not(hl7:translation/@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-14-CD: translation displayName only if code (hl7:translation/@code or not(hl7:translation/@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="matches(@displayName,'[\r\n\t]')">
         <xsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to
        interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="code" select="@code"/>

		    <!--REPORT warning-->
<xsl:if test="@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))">
         <xsl:message>Datatype CD: waarschuwing: onbekend codeSystem '<xsl:text/>
            <xsl:value-of select="@codeSystem"/>
            <xsl:text/>' gevonden met codeSystemName 
        '<xsl:text/>
            <xsl:value-of select="./@codeSystemName"/>
            <xsl:text/>'. Bestand '<xsl:text/>
            <xsl:value-of select="concat('../vocab/',@codeSystem,'.xml')"/>
            <xsl:text/>' ontbreekt. (@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml'))) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="hl7:translation[@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))]">
         <xsl:message>Datatype CD: waarschuwing: onbekend codeSystem '<xsl:text/>
            <xsl:value-of select="hl7:translation/@codeSystem"/>
            <xsl:text/>' in translation (hl7:translation[@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="if (@codeSystem and doc-available(concat('../vocab/',@codeSystem,'.xml')) and (         document(concat('../vocab/',@codeSystem,'.xml'))/*[@codeStrength='CNE'] or         not(document(concat('../vocab/',@codeSystem,'.xml'))/*/@codeStrength))) then (          not(document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:code[@code=$code]) ) else ( 0=1 )">
         <xsl:message>Datatype CD: waarschuwing: onbekende code '<xsl:text/>
            <xsl:value-of select="$code"/>
            <xsl:text/>' gevonden in codeSystem '<xsl:text/>
            <xsl:value-of select="@codeSystem"/>
            <xsl:text/>'
        gevonden met displayName '<xsl:text/>
            <xsl:value-of select="./@displayName"/>
            <xsl:text/>'. Waarde ontbreekt in 
        '<xsl:text/>
            <xsl:value-of select="concat('../vocab/',@codeSystem,'.xml')"/>
            <xsl:text/>' (<xsl:text/>
            <xsl:value-of select="document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:name"/>
            <xsl:text/>). (if (@codeSystem and doc-available(concat('../vocab/',@codeSystem,'.xml')) and ( document(concat('../vocab/',@codeSystem,'.xml'))/*[@codeStrength='CNE'] or not(document(concat('../vocab/',@codeSystem,'.xml'))/*/@codeStrength))) then ( not(document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:code[@code=$code]) ) else ( 0=1 ) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no originalText on translations (not(hl7:translation/hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no translation on translations (not(hl7:translation/hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no null on translations (not(hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@code)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation code requires codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation codeSystemName only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation codeSystemVersion only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@code or not(hl7:translation/@displayName)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation displayName only if code (hl7:translation/@code or not(hl7:translation/@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="self::hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(../hl7:id/@root='2.16.528.1.1007.3.1') or          document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: UZI rolcode attribuut code moet een geldige RoleCodeNL bevatten (not(../hl7:id/@root='2.16.528.1.1007.3.1') or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="self::hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or not(../hl7:id/@root='2.16.528.1.1007.3.3') or          document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: organisatie rolcode attribuut code moet een geldige AssignedRoleType bevatten (@nullFlavor or not(../hl7:id/@root='2.16.528.1.1007.3.3') or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CE: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant/hl7:AssignedPerson/hl7:telecom"
                 priority="1037"
                 mode="M5">
      <xsl:variable name="urlScheme" select="substring-before(@value,':')"/>
      <xsl:variable name="urlStr" select="substring-after(@value,':')"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-URL: elements of type URL SHALL have a @value attribute. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value=iri-to-uri(@value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-URL: @value must be a valid URI, e.g. '<xsl:text/>
               <xsl:value-of select="iri-to-uri(@value)"/>
               <xsl:text/>'. (@value=iri-to-uri(@value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: Telecom elementen moeten een value attribuut hebben. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value=iri-to-uri(@value)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: Een telecom value moet een geldige URI zijn, bijvoorbeeld '<xsl:text/>
               <xsl:value-of select="iri-to-uri(@value)"/>
               <xsl:text/>'. (@value=iri-to-uri(@value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="urlScheme" select="substring-before(@value,':')"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value and document('../vocab/URL-urlScheme.xml')/*/hl7:code[@code=$urlScheme]"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: Telecom value moet een in Nederland geldig URL scheme hebben. Gevonden '<xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/>' (@value and document('../vocab/URL-urlScheme.xml')/*/hl7:code[@code=$urlScheme] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="urlStr" select="substring-after(@value,':')"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='tel' or $urlScheme='fax') then (         matches($urlStr,'^(\+?([\d()./-]|(%[a-f\d]{2}))+)*(;(phone-context=((\+?([\d()./-]|(%[a-f\d]{2}))+)|(([a-z\d-]|(%[a-f\d]{2}))+(\.([a-z\d-]|(%[a-f\d]{2}))+)*))|(ext=[\d./-]+)|(isub=(([a-z\d();/?:@&amp;=+$,_.!~*-])|(%[a-f\d]{2}))+)|([a-z\d-]+=([a-z\d\[\]/:&amp;+$_.!~*()-]|(%[a-f\d]{2}))+)))*$')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 3966 (if ($urlScheme='tel' or $urlScheme='fax') then ( matches($urlStr,'^(\+?([\d()./-]|(%[a-f\d]{2}))+)*(;(phone-context=((\+?([\d()./-]|(%[a-f\d]{2}))+)|(([a-z\d-]|(%[a-f\d]{2}))+(\.([a-z\d-]|(%[a-f\d]{2}))+)*))|(ext=[\d./-]+)|(isub=(([a-z\d();/?:@&amp;=+$,_.!~*-])|(%[a-f\d]{2}))+)|([a-z\d-]+=([a-z\d\[\]/:&amp;+$_.!~*()-]|(%[a-f\d]{2}))+)))*$') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc3966)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='file') then (         matches($urlStr,'^///{0,2}((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 1738. (if ($urlScheme='file') then ( matches($urlStr,'^///{0,2}((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc1738)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='nfs') then (         matches($urlStr,'^//((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))/?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 2224. (if ($urlScheme='nfs') then ( matches($urlStr,'^//((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))/?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc2224)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='ftp' or $urlScheme='ftps') then (         matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;=~_-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z][\w-]*))?)?(/(([a-z\d$\.+!*(),?&amp;_~=-])|(%[a-f\d]{2}))*)*(;type=[aid])?$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 1738. (if ($urlScheme='ftp' or $urlScheme='ftps') then ( matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;=~_-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z][\w-]*))?)?(/(([a-z\d$\.+!*(),?&amp;_~=-])|(%[a-f\d]{2}))*)*(;type=[aid])?$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc1738)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='http' or $urlScheme='https') then (         matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*(\?(([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*(&amp;((([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*)?)*)?(#([\w~!$+|.,*:=~_]|%[a-f\d]{2})*)?$', 'i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 1738 (if ($urlScheme='http' or $urlScheme='https') then ( matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*(\?(([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*(&amp;((([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*)?)*)?(#([\w~!$+|.,*:=~_]|%[a-f\d]{2})*)?$', 'i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc1738)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='telnet') then (         matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)*$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 1738. (if ($urlScheme='telnet') then ( matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)*$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc1738)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='mailto') then (         matches($urlStr,'^[\w$\.+!*(),?&amp;~_=-]+(\.[\w$\.+!*(),?&amp;~_=-]+)*@([\w$+!*(),?&amp;~_=-]+\.)+([a-z]{2,4})$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 2368. Merk op dat het niet toegestaan is extra headers op te nemen (if ($urlScheme='mailto') then ( matches($urlStr,'^[\w$\.+!*(),?&amp;~_=-]+(\.[\w$\.+!*(),?&amp;~_=-]+)*@([\w$+!*(),?&amp;~_=-]+\.)+([a-z]{2,4})$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc2368)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='x-hl7-applicatie') then (         matches($urlStr,'^2\.16\.840\.1\.113883\.2\.4\.6\.6\.[1-9]\d+$')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten beginnen met "2.16.840.1.113883.2.4.6.6." gevolgd door een numeriek deel (if ($urlScheme='x-hl7-applicatie') then ( matches($urlStr,'^2\.16\.840\.1\.113883\.2\.4\.6\.6\.[1-9]\d+$') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='mllp') then (         matches($urlStr,'^//(([1-2]\d{0,2})(\.([1-2]\d{0,2})){3}|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2}))):(([1-9]\d{0,4})|([A-Za-z]\w*))/$')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan mllp://host:port/ waarbij 'host' een naam of IP kan zijn en 'port' een benoemde poort of een nummer (if ($urlScheme='mllp') then ( matches($urlStr,'^//(([1-2]\d{0,2})(\.([1-2]\d{0,2})){3}|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2}))):(([1-9]\d{0,4})|([A-Za-z]\w*))/$') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor and hl7:usablePeriod)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-TEL: not null and usablePeriod (not(@nullFlavor and hl7:usablePeriod) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant/hl7:AssignedPerson/hl7:name"
                 priority="1036"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-EN: entity name shall be null or text only or element only (no mixed content) (@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="*[not(@nullFlavor)][normalize-space(.)='']">
         <xsl:message>dtr1-3-EN: empty name particles should not be present. (*[not(@nullFlavor)][normalize-space(.)=''] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="substring(normalize-space(.),1,1)='&#34;'">
         <xsl:message>dtr1-4-EN: Use of quotes at the beginning of a name are probably not correct. (substring(normalize-space(.),1,1)='"' / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:given[contains(@qualifier,'IN')]) or hl7:given[contains(@qualifier,'IN') and not(starts-with(text(),'.')) and contains(text(),'.') and ends-with(text(),'.')]"/>
         <xsl:otherwise>
            <xsl:message>Datatype PN: als given/@qualifier 'IN' bevat dan moeten er initialen gescheiden en gevolgd door een punt in het element given staan. (not(hl7:given[contains(@qualifier,'IN')]) or hl7:given[contains(@qualifier,'IN') and not(starts-with(text(),'.')) and contains(text(),'.') and ends-with(text(),'.')] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:given[contains(@qualifier,'IN') and contains(@qualifier,'CL')])"/>
         <xsl:otherwise>
            <xsl:message>Datatype PN: given/@qualifier 'IN' en 'CL' gaan niet samen. Initalen zijn geen roepnaam (not(hl7:given[contains(@qualifier,'IN') and contains(@qualifier,'CL')]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:given[contains(@qualifier,'CL') and contains(text(),'.')])"/>
         <xsl:otherwise>
            <xsl:message>Datatype PN: als given/@qualifier 'CL' bevat dan moeten er voornamen in dit element staan. Voornamen hebben geen puntjes. (not(hl7:given[contains(@qualifier,'CL') and contains(text(),'.')]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="hl7:prefix[@qualifier='VV' and not(ends-with(text(),' '))]">
         <xsl:message>Datatype PN: als er een spatie tussen een voorvoegsel en de bijbehorende achternaam hoort, moet het prefix element met qualifier=VV ook eindigen met een spatie. (hl7:prefix[@qualifier='VV' and not(ends-with(text(),' '))] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="hl7:family[substring(.,1,4)='van '] or hl7:family[substring(.,1,3)='de ']">
         <xsl:message>Datatype PN: voorvoegsels moeten in het prefix element worden gevoerd, tenzij het bronsysteem voorvoegsels en achternaam niet gescheiden vastlegt. (hl7:family[substring(.,1,4)='van '] or hl7:family[substring(.,1,3)='de '] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:noteText"
                 priority="1035"
                 mode="M5">

		<!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/<xsl:text/>
               <xsl:value-of select="local-name()"/>
               <xsl:text/> niet gebruiken (false() / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:time"
                 priority="1034"
                 mode="M5">

		<!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/<xsl:text/>
               <xsl:value-of select="local-name()"/>
               <xsl:text/> niet gebruiken (false() / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:modeCode"
                 priority="1033"
                 mode="M5">

		<!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/<xsl:text/>
               <xsl:value-of select="local-name()"/>
               <xsl:text/> niet gebruiken (false() / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:signatureCode"
                 priority="1032"
                 mode="M5">

		<!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/<xsl:text/>
               <xsl:value-of select="local-name()"/>
               <xsl:text/> niet gebruiken (false() / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:signatureText"
                 priority="1031"
                 mode="M5">

		<!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/<xsl:text/>
               <xsl:value-of select="local-name()"/>
               <xsl:text/> niet gebruiken (false() / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant/hl7:AssignedPerson/hl7:Organization/hl7:id"
                 priority="1030"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn (not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: AGB-code moet 8 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef (not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue" select="@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: @extension moet een geldige interactie-id bevatten (not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant/hl7:AssignedPerson/hl7:Organization/hl7:code"
                 priority="1029"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@code or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@code))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CD: no code if null (not(@nullFlavor) or (@nullFlavor and not(@code)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CD: no displayName if null (not(@nullFlavor) or (@nullFlavor and not(@displayName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CD: no originalText on translations (not(hl7:translation/hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-CD: no null on translations (not(hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-11-CD: translation code requires codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@code or not(hl7:translation/@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-14-CD: translation displayName only if code (hl7:translation/@code or not(hl7:translation/@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="matches(@displayName,'[\r\n\t]')">
         <xsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to
        interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="code" select="@code"/>

		    <!--REPORT warning-->
<xsl:if test="@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))">
         <xsl:message>Datatype CD: waarschuwing: onbekend codeSystem '<xsl:text/>
            <xsl:value-of select="@codeSystem"/>
            <xsl:text/>' gevonden met codeSystemName 
        '<xsl:text/>
            <xsl:value-of select="./@codeSystemName"/>
            <xsl:text/>'. Bestand '<xsl:text/>
            <xsl:value-of select="concat('../vocab/',@codeSystem,'.xml')"/>
            <xsl:text/>' ontbreekt. (@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml'))) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="hl7:translation[@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))]">
         <xsl:message>Datatype CD: waarschuwing: onbekend codeSystem '<xsl:text/>
            <xsl:value-of select="hl7:translation/@codeSystem"/>
            <xsl:text/>' in translation (hl7:translation[@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="if (@codeSystem and doc-available(concat('../vocab/',@codeSystem,'.xml')) and (         document(concat('../vocab/',@codeSystem,'.xml'))/*[@codeStrength='CNE'] or         not(document(concat('../vocab/',@codeSystem,'.xml'))/*/@codeStrength))) then (          not(document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:code[@code=$code]) ) else ( 0=1 )">
         <xsl:message>Datatype CD: waarschuwing: onbekende code '<xsl:text/>
            <xsl:value-of select="$code"/>
            <xsl:text/>' gevonden in codeSystem '<xsl:text/>
            <xsl:value-of select="@codeSystem"/>
            <xsl:text/>'
        gevonden met displayName '<xsl:text/>
            <xsl:value-of select="./@displayName"/>
            <xsl:text/>'. Waarde ontbreekt in 
        '<xsl:text/>
            <xsl:value-of select="concat('../vocab/',@codeSystem,'.xml')"/>
            <xsl:text/>' (<xsl:text/>
            <xsl:value-of select="document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:name"/>
            <xsl:text/>). (if (@codeSystem and doc-available(concat('../vocab/',@codeSystem,'.xml')) and ( document(concat('../vocab/',@codeSystem,'.xml'))/*[@codeStrength='CNE'] or not(document(concat('../vocab/',@codeSystem,'.xml'))/*/@codeStrength))) then ( not(document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:code[@code=$code]) ) else ( 0=1 ) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no originalText on translations (not(hl7:translation/hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no translation on translations (not(hl7:translation/hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no null on translations (not(hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@code)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation code requires codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation codeSystemName only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation codeSystemVersion only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@code or not(hl7:translation/@displayName)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation displayName only if code (hl7:translation/@code or not(hl7:translation/@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="self::hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(../hl7:id/@root='2.16.528.1.1007.3.1') or          document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: UZI rolcode attribuut code moet een geldige RoleCodeNL bevatten (not(../hl7:id/@root='2.16.528.1.1007.3.1') or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="self::hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or not(../hl7:id/@root='2.16.528.1.1007.3.3') or          document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: organisatie rolcode attribuut code moet een geldige AssignedRoleType bevatten (@nullFlavor or not(../hl7:id/@root='2.16.528.1.1007.3.3') or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CE: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant/hl7:AssignedPerson/hl7:Organization/hl7:telecom"
                 priority="1028"
                 mode="M5">
      <xsl:variable name="urlScheme" select="substring-before(@value,':')"/>
      <xsl:variable name="urlStr" select="substring-after(@value,':')"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-URL: elements of type URL SHALL have a @value attribute. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value=iri-to-uri(@value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-URL: @value must be a valid URI, e.g. '<xsl:text/>
               <xsl:value-of select="iri-to-uri(@value)"/>
               <xsl:text/>'. (@value=iri-to-uri(@value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: Telecom elementen moeten een value attribuut hebben. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value=iri-to-uri(@value)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: Een telecom value moet een geldige URI zijn, bijvoorbeeld '<xsl:text/>
               <xsl:value-of select="iri-to-uri(@value)"/>
               <xsl:text/>'. (@value=iri-to-uri(@value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="urlScheme" select="substring-before(@value,':')"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value and document('../vocab/URL-urlScheme.xml')/*/hl7:code[@code=$urlScheme]"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: Telecom value moet een in Nederland geldig URL scheme hebben. Gevonden '<xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/>' (@value and document('../vocab/URL-urlScheme.xml')/*/hl7:code[@code=$urlScheme] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="urlStr" select="substring-after(@value,':')"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='tel' or $urlScheme='fax') then (         matches($urlStr,'^(\+?([\d()./-]|(%[a-f\d]{2}))+)*(;(phone-context=((\+?([\d()./-]|(%[a-f\d]{2}))+)|(([a-z\d-]|(%[a-f\d]{2}))+(\.([a-z\d-]|(%[a-f\d]{2}))+)*))|(ext=[\d./-]+)|(isub=(([a-z\d();/?:@&amp;=+$,_.!~*-])|(%[a-f\d]{2}))+)|([a-z\d-]+=([a-z\d\[\]/:&amp;+$_.!~*()-]|(%[a-f\d]{2}))+)))*$')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 3966 (if ($urlScheme='tel' or $urlScheme='fax') then ( matches($urlStr,'^(\+?([\d()./-]|(%[a-f\d]{2}))+)*(;(phone-context=((\+?([\d()./-]|(%[a-f\d]{2}))+)|(([a-z\d-]|(%[a-f\d]{2}))+(\.([a-z\d-]|(%[a-f\d]{2}))+)*))|(ext=[\d./-]+)|(isub=(([a-z\d();/?:@&amp;=+$,_.!~*-])|(%[a-f\d]{2}))+)|([a-z\d-]+=([a-z\d\[\]/:&amp;+$_.!~*()-]|(%[a-f\d]{2}))+)))*$') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc3966)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='file') then (         matches($urlStr,'^///{0,2}((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 1738. (if ($urlScheme='file') then ( matches($urlStr,'^///{0,2}((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc1738)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='nfs') then (         matches($urlStr,'^//((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))/?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 2224. (if ($urlScheme='nfs') then ( matches($urlStr,'^//((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))/?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc2224)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='ftp' or $urlScheme='ftps') then (         matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;=~_-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z][\w-]*))?)?(/(([a-z\d$\.+!*(),?&amp;_~=-])|(%[a-f\d]{2}))*)*(;type=[aid])?$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 1738. (if ($urlScheme='ftp' or $urlScheme='ftps') then ( matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;=~_-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z][\w-]*))?)?(/(([a-z\d$\.+!*(),?&amp;_~=-])|(%[a-f\d]{2}))*)*(;type=[aid])?$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc1738)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='http' or $urlScheme='https') then (         matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*(\?(([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*(&amp;((([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*)?)*)?(#([\w~!$+|.,*:=~_]|%[a-f\d]{2})*)?$', 'i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 1738 (if ($urlScheme='http' or $urlScheme='https') then ( matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*(\?(([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*(&amp;((([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*)?)*)?(#([\w~!$+|.,*:=~_]|%[a-f\d]{2})*)?$', 'i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc1738)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='telnet') then (         matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)*$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 1738. (if ($urlScheme='telnet') then ( matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)*$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc1738)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='mailto') then (         matches($urlStr,'^[\w$\.+!*(),?&amp;~_=-]+(\.[\w$\.+!*(),?&amp;~_=-]+)*@([\w$+!*(),?&amp;~_=-]+\.)+([a-z]{2,4})$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 2368. Merk op dat het niet toegestaan is extra headers op te nemen (if ($urlScheme='mailto') then ( matches($urlStr,'^[\w$\.+!*(),?&amp;~_=-]+(\.[\w$\.+!*(),?&amp;~_=-]+)*@([\w$+!*(),?&amp;~_=-]+\.)+([a-z]{2,4})$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc2368)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='x-hl7-applicatie') then (         matches($urlStr,'^2\.16\.840\.1\.113883\.2\.4\.6\.6\.[1-9]\d+$')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten beginnen met "2.16.840.1.113883.2.4.6.6." gevolgd door een numeriek deel (if ($urlScheme='x-hl7-applicatie') then ( matches($urlStr,'^2\.16\.840\.1\.113883\.2\.4\.6\.6\.[1-9]\d+$') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='mllp') then (         matches($urlStr,'^//(([1-2]\d{0,2})(\.([1-2]\d{0,2})){3}|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2}))):(([1-9]\d{0,4})|([A-Za-z]\w*))/$')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan mllp://host:port/ waarbij 'host' een naam of IP kan zijn en 'port' een benoemde poort of een nummer (if ($urlScheme='mllp') then ( matches($urlStr,'^//(([1-2]\d{0,2})(\.([1-2]\d{0,2})){3}|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2}))):(([1-9]\d{0,4})|([A-Za-z]\w*))/$') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor and hl7:usablePeriod)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-TEL: not null and usablePeriod (not(@nullFlavor and hl7:usablePeriod) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant/hl7:AssignedPerson/hl7:Organization/hl7:name"
                 priority="1027"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-EN: entity name shall be null or text only or element only (no mixed content) (@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="*[not(@nullFlavor)][normalize-space(.)='']">
         <xsl:message>dtr1-3-EN: empty name particles should not be present. (*[not(@nullFlavor)][normalize-space(.)=''] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="substring(normalize-space(.),1,1)='&#34;'">
         <xsl:message>dtr1-4-EN: Use of quotes at the beginning of a name are probably not correct. (substring(normalize-space(.),1,1)='"' / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(hl7:family)=0 and count(hl7:given)=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ON: no parts may be person name type particles (count(hl7:family)=0 and count(hl7:given)=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(*)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-ON: organization names SHALL be element content (not(*) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant/hl7:AssignedPerson/hl7:Organization/hl7:addr"
                 priority="1026"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (count(*)&gt;0 and not(text()[string-length(normalize-space())&gt;0])) or (count(*)=0 and text()[string-length(normalize-space())&gt;0])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-AD: address shall be null or text only or element only (no mixed content) (@nullFlavor or (count(*)&gt;0 and not(text()[string-length(normalize-space())&gt;0])) or (count(*)=0 and text()[string-length(normalize-space())&gt;0]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:useablePeriod/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-AD: no useablePeriod if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:useablePeriod/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(*[self::hl7:useablePeriod][@updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-AD: updateMode shall not be used on address elements (count(*[self::hl7:useablePeriod][@updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or          string-length(hl7:useablePeriod/hl7:low/@value) = string-length(hl7:useablePeriod/hl7:high/@value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-AD: useablePeriod/low/@value must have the same precision as useablePeriod/high/@value (not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or string-length(hl7:useablePeriod/hl7:low/@value) = string-length(hl7:useablePeriod/hl7:high/@value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or         number(substring(concat(hl7:useablePeriod/hl7:low/@value,'00000000000000'),1,14)) &lt; number(substring(concat(hl7:useablePeriod/hl7:high/@value,'00000000000000'),1,14))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-AD: useablePeriod/low/@value must be before useablePeriod/high/@value (not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or number(substring(concat(hl7:useablePeriod/hl7:low/@value,'00000000000000'),1,14)) &lt; number(substring(concat(hl7:useablePeriod/hl7:high/@value,'00000000000000'),1,14)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="tum" select="'^(us|ms|s|min|h|d|wk|mo|a|)$'"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="matches(hl7:useablePeriod/hl7:width/@unit, $tum)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-AD: for useablePeriod/width only us (microseconds), ms (milliseconds), s (seconds), min (minute), h (hours), d (day), wk (week), mo (month) or a (year) are allowed (matches(hl7:useablePeriod/hl7:width/@unit, $tum) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="postalCodeText" select="hl7:postalCode/text()"/>
      <xsl:variable name="countryCode" select="hl7:country/@code"/>
      <xsl:variable name="countryCodeSystem" select="hl7:country/@codeSystem"/>
      <xsl:variable name="countryText" select="upper-case(normalize-space(hl7:country))"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if (@codeSystem='2.16.840.1.113883.2.4.4.15') then (         matches(@code,'^[0-9]{4}[A-Z]{2}$')         ) else ( 1=1 )"/>
         <xsl:otherwise>
            <xsl:message>Datatype AD: postcodes onder codeSystem '2.16.840.1.113883.2.4.4.15' moeten voldoen aan '9999AA' (if (@codeSystem='2.16.840.1.113883.2.4.4.15') then ( matches(@code,'^[0-9]{4}[A-Z]{2}$') ) else ( 1=1 ) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:additionalLocator/text()=('to','by') or not(matches(hl7:postalCode/text(),'^[0-9]{4} [A-Z]{2}$')) or not(hl7:additionalLocator)"/>
         <xsl:otherwise>
            <xsl:message>Datatype AD: In een Nederlands adres kan additionalLocator alleen de waarden 'to' of 'by' bevatten (hl7:additionalLocator/text()=('to','by') or not(matches(hl7:postalCode/text(),'^[0-9]{4} [A-Z]{2}$')) or not(hl7:additionalLocator) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if (hl7:postalCode/text() and (not(hl7:country) or          ($countryCode='NL' and ($countryCodeSystem='2.16.1' or $countryCodeSystem='1.3.6.1.4.1.1466.115.121.1.11' or $countryCodeSystem='1.0.3166.1.2.2')) or         ($countryCode='NLD' and $countryCodeSystem='2.16.2') or         ($countryCode='528' and $countryCodeSystem='2.16.3') or         $countryText='NL' or         $countryText='NLD' or         $countryText='NEDERLAND'         )) then ( matches($postalCodeText,'^[0-9]{4} [A-Z]{2}$')         ) else ( 1=1 )"/>
         <xsl:otherwise>
            <xsl:message>Datatype AD: Nederlandse postcodes in de text-nodes moeten voldoen aan '9999 AA' (if (hl7:postalCode/text() and (not(hl7:country) or ($countryCode='NL' and ($countryCodeSystem='2.16.1' or $countryCodeSystem='1.3.6.1.4.1.1466.115.121.1.11' or $countryCodeSystem='1.0.3166.1.2.2')) or ($countryCode='NLD' and $countryCodeSystem='2.16.2') or ($countryCode='528' and $countryCodeSystem='2.16.3') or $countryText='NL' or $countryText='NLD' or $countryText='NEDERLAND' )) then ( matches($postalCodeText,'^[0-9]{4} [A-Z]{2}$') ) else ( 1=1 ) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="illegalAddressPart"
                    select="*[local-name(.)!='delimiter' and local-name(.)!='buildingNumberSuffix' and         local-name(.)!='country' and local-name(.)!='county' and         local-name(.)!='city' and local-name(.)!='postalCode' and         local-name(.)!='houseNumber' and local-name(.)!='streetName' and         local-name(.)!='additionalLocator'][1]/name()"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(*)=0 or string-length($illegalAddressPart)=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype AD: binnen Nederland mogen alleen delimiter, country, county, 
        city, postalCode, houseNumber, buildingNumberSuffix, streetName en additionalLocator worden gebruikt. Gevonden '<xsl:text/>
               <xsl:value-of select="$illegalAddressPart"/>
               <xsl:text/>'. (count(*)=0 or string-length($illegalAddressPart)=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(*)=0 or count(*[not(self::hl7:postalCode) and not(self::hl7:country) and @code])=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype AD: alleen postalCode en country 
        kunnen gecodeerd worden. Gevonden '<xsl:text/>
               <xsl:value-of select="*[not(self::hl7:postalCode) and not(self::hl7:country) and @code][1]/name()"/>
               <xsl:text/>' (count(*)=0 or count(*[not(self::hl7:postalCode) and not(self::hl7:country) and @code])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant/hl7:AssignedDevice"
                 priority="1024"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(hl7:id[@root='2.16.528.1.1007.3.2' or @root='2.16.840.1.113883.2.4.6.6' or @root='2.16.528.1.1007.4'])&gt;=1"/>
         <xsl:otherwise>
            <xsl:message>Control Act: authorOrPerformer/*/AssignedDevice/id. Tenminste één id moet als root 2.16.528.1.1007.3.2 (UZI-systemen), 2.16.840.1.113883.2.4.6.6 (Applicatie-id) of 2.16.528.1.1007.4 (SBV-Z) hebben (count(hl7:id[@root='2.16.528.1.1007.3.2' or @root='2.16.840.1.113883.2.4.6.6' or @root='2.16.528.1.1007.4'])&gt;=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3']) or hl7:id[@root='2.16.528.1.1007.3.2']"/>
         <xsl:otherwise>
            <xsl:message>Control Act: authorOrPerformer/*/AssignedDevice/id moet tenminste het UZI-nummer systemen bevatten voor een XIS in een GBZ (not(hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3']) or hl7:id[@root='2.16.528.1.1007.3.2'] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:id[@root='2.16.528.1.1007.3.2']) or hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3' and @extension]"/>
         <xsl:otherwise>
            <xsl:message>Control Act: authorOrPerformer/*/AssignedDevice/Organization/id moet de zorgaanbieder van het XIS identificeren (not(hl7:id[@root='2.16.528.1.1007.3.2']) or hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3' and @extension] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="hl7:id[(@root='2.16.840.1.113883.2.4.6.6' and @extension='1') or @root='2.16.528.1.1007.4'] or hl7:Organization/hl7:id"/>
         <xsl:otherwise>
            <xsl:message>Control Act: authorOrPerformer/*/AssignedDevice moet een geïdentificeerde organisatie hebben, tenzij het de ZIM of het SBV-Z betreft. (hl7:id[(@root='2.16.840.1.113883.2.4.6.6' and @extension='1') or @root='2.16.528.1.1007.4'] or hl7:Organization/hl7:id / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant/hl7:AssignedDevice/hl7:id"
                 priority="1022"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn (not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: AGB-code moet 8 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef (not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue" select="@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: @extension moet een geldige interactie-id bevatten (not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="autIdExt" select="@extension"/>
      <xsl:variable name="sendIdExt"
                    select="../../../../../hl7:sender/hl7:device/hl7:id[@root='2.16.840.1.113883.2.4.6.6']/@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@root='2.16.528.1.1007.3.2' or @root='2.16.840.1.113883.2.4.6.6' or @root='2.16.528.1.1007.4'"/>
         <xsl:otherwise>
            <xsl:message>Control Act: authorOrPerformer/*/AssignedDevice/id. @root 2.16.528.1.1007.3.2 (UZI-systemen), 2.16.840.1.113883.2.4.6.6 (Applicatie-id) of 2.16.528.1.1007.4 (SBV-Z) zijn (@root='2.16.528.1.1007.3.2' or @root='2.16.840.1.113883.2.4.6.6' or @root='2.16.528.1.1007.4' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="$sendIdExt=$autIdExt or not(@root='2.16.840.1.113883.2.4.6.6') or empty($sendIdExt) or $sendIdExt='1'"/>
         <xsl:otherwise>
            <xsl:message>Control Act: authorOrPerformer/*/AssignedDevice/id. Applicatie-id <xsl:text/>
               <xsl:value-of select="$autIdExt"/>
               <xsl:text/> komt niet overeen met Transmission-wrapper sender <xsl:text/>
               <xsl:value-of select="$sendIdExt"/>
               <xsl:text/>. ($sendIdExt=$autIdExt or not(@root='2.16.840.1.113883.2.4.6.6') or empty($sendIdExt) or $sendIdExt='1' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.6' and @extension='1' and following-sibling::hl7:Organization)"/>
         <xsl:otherwise>
            <xsl:message>Control Act: authorOrPerformer/*/AssignedDevice/id. De verantwoordelijke organisatie voor de ZIM moet niet worden meegegeven (not(@root='2.16.840.1.113883.2.4.6.6' and @extension='1' and following-sibling::hl7:Organization) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant/hl7:AssignedDevice/hl7:code"
                 priority="1021"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@code or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@code))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CD: no code if null (not(@nullFlavor) or (@nullFlavor and not(@code)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CD: no displayName if null (not(@nullFlavor) or (@nullFlavor and not(@displayName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CD: no originalText on translations (not(hl7:translation/hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-CD: no null on translations (not(hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-11-CD: translation code requires codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@code or not(hl7:translation/@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-14-CD: translation displayName only if code (hl7:translation/@code or not(hl7:translation/@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="matches(@displayName,'[\r\n\t]')">
         <xsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to
        interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="code" select="@code"/>

		    <!--REPORT warning-->
<xsl:if test="@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))">
         <xsl:message>Datatype CD: waarschuwing: onbekend codeSystem '<xsl:text/>
            <xsl:value-of select="@codeSystem"/>
            <xsl:text/>' gevonden met codeSystemName 
        '<xsl:text/>
            <xsl:value-of select="./@codeSystemName"/>
            <xsl:text/>'. Bestand '<xsl:text/>
            <xsl:value-of select="concat('../vocab/',@codeSystem,'.xml')"/>
            <xsl:text/>' ontbreekt. (@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml'))) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="hl7:translation[@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))]">
         <xsl:message>Datatype CD: waarschuwing: onbekend codeSystem '<xsl:text/>
            <xsl:value-of select="hl7:translation/@codeSystem"/>
            <xsl:text/>' in translation (hl7:translation[@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="if (@codeSystem and doc-available(concat('../vocab/',@codeSystem,'.xml')) and (         document(concat('../vocab/',@codeSystem,'.xml'))/*[@codeStrength='CNE'] or         not(document(concat('../vocab/',@codeSystem,'.xml'))/*/@codeStrength))) then (          not(document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:code[@code=$code]) ) else ( 0=1 )">
         <xsl:message>Datatype CD: waarschuwing: onbekende code '<xsl:text/>
            <xsl:value-of select="$code"/>
            <xsl:text/>' gevonden in codeSystem '<xsl:text/>
            <xsl:value-of select="@codeSystem"/>
            <xsl:text/>'
        gevonden met displayName '<xsl:text/>
            <xsl:value-of select="./@displayName"/>
            <xsl:text/>'. Waarde ontbreekt in 
        '<xsl:text/>
            <xsl:value-of select="concat('../vocab/',@codeSystem,'.xml')"/>
            <xsl:text/>' (<xsl:text/>
            <xsl:value-of select="document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:name"/>
            <xsl:text/>). (if (@codeSystem and doc-available(concat('../vocab/',@codeSystem,'.xml')) and ( document(concat('../vocab/',@codeSystem,'.xml'))/*[@codeStrength='CNE'] or not(document(concat('../vocab/',@codeSystem,'.xml'))/*/@codeStrength))) then ( not(document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:code[@code=$code]) ) else ( 0=1 ) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no originalText on translations (not(hl7:translation/hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no translation on translations (not(hl7:translation/hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no null on translations (not(hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@code)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation code requires codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation codeSystemName only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation codeSystemVersion only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@code or not(hl7:translation/@displayName)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation displayName only if code (hl7:translation/@code or not(hl7:translation/@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="self::hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(../hl7:id/@root='2.16.528.1.1007.3.1') or          document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: UZI rolcode attribuut code moet een geldige RoleCodeNL bevatten (not(../hl7:id/@root='2.16.528.1.1007.3.1') or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="self::hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or not(../hl7:id/@root='2.16.528.1.1007.3.3') or          document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: organisatie rolcode attribuut code moet een geldige AssignedRoleType bevatten (@nullFlavor or not(../hl7:id/@root='2.16.528.1.1007.3.3') or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CE: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CV: cannot have translation (not(hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant/hl7:AssignedDevice/hl7:Organization/hl7:id"
                 priority="1020"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn (not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: AGB-code moet 8 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef (not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue" select="@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: @extension moet een geldige interactie-id bevatten (not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="@root='2.16.528.1.1007.3.3' or @root='2.16.840.1.113883.2.4.3.11.25' or (@root='2.16.840.1.113883.2.4.3.11' and @extension='7') or (@root ='2.16.528.1.1007' and @extension='4')"/>
         <xsl:otherwise>
            <xsl:message>Control Act: authorOrPerformer/*/AssignedDevice/Organization/id heeft onbekende waarde '@root="<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" @extension="<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>" @nullFlavor="<xsl:text/>
               <xsl:value-of select="@nullFlavor"/>
               <xsl:text/>"'. Dit is geen GBZ (2.16.528.1.1007.3.3), GBO/GBP (2.16.840.1.113883.2.4.3.11.25), GBK (2.16.840.1.113883.2.4.3.11 / 7), SBV_Z (2.16.528.1.1007 / 4) (@root='2.16.528.1.1007.3.3' or @root='2.16.840.1.113883.2.4.3.11.25' or (@root='2.16.840.1.113883.2.4.3.11' and @extension='7') or (@root ='2.16.528.1.1007' and @extension='4') / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="not(@root) or ../hl7:name"/>
         <xsl:otherwise>
            <xsl:message>Control Act: authorOrPerformer/*/AssignedDevice/Organization/name is verplicht voor GBx organisaties. (not(@root) or ../hl7:name / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant/hl7:AssignedDevice/hl7:Organization/hl7:code"
                 priority="1019"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@code or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@code))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CD: no code if null (not(@nullFlavor) or (@nullFlavor and not(@code)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CD: no displayName if null (not(@nullFlavor) or (@nullFlavor and not(@displayName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CD: no originalText on translations (not(hl7:translation/hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-CD: no null on translations (not(hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-11-CD: translation code requires codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@code or not(hl7:translation/@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-14-CD: translation displayName only if code (hl7:translation/@code or not(hl7:translation/@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="matches(@displayName,'[\r\n\t]')">
         <xsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to
        interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="code" select="@code"/>

		    <!--REPORT warning-->
<xsl:if test="@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))">
         <xsl:message>Datatype CD: waarschuwing: onbekend codeSystem '<xsl:text/>
            <xsl:value-of select="@codeSystem"/>
            <xsl:text/>' gevonden met codeSystemName 
        '<xsl:text/>
            <xsl:value-of select="./@codeSystemName"/>
            <xsl:text/>'. Bestand '<xsl:text/>
            <xsl:value-of select="concat('../vocab/',@codeSystem,'.xml')"/>
            <xsl:text/>' ontbreekt. (@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml'))) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="hl7:translation[@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))]">
         <xsl:message>Datatype CD: waarschuwing: onbekend codeSystem '<xsl:text/>
            <xsl:value-of select="hl7:translation/@codeSystem"/>
            <xsl:text/>' in translation (hl7:translation[@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="if (@codeSystem and doc-available(concat('../vocab/',@codeSystem,'.xml')) and (         document(concat('../vocab/',@codeSystem,'.xml'))/*[@codeStrength='CNE'] or         not(document(concat('../vocab/',@codeSystem,'.xml'))/*/@codeStrength))) then (          not(document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:code[@code=$code]) ) else ( 0=1 )">
         <xsl:message>Datatype CD: waarschuwing: onbekende code '<xsl:text/>
            <xsl:value-of select="$code"/>
            <xsl:text/>' gevonden in codeSystem '<xsl:text/>
            <xsl:value-of select="@codeSystem"/>
            <xsl:text/>'
        gevonden met displayName '<xsl:text/>
            <xsl:value-of select="./@displayName"/>
            <xsl:text/>'. Waarde ontbreekt in 
        '<xsl:text/>
            <xsl:value-of select="concat('../vocab/',@codeSystem,'.xml')"/>
            <xsl:text/>' (<xsl:text/>
            <xsl:value-of select="document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:name"/>
            <xsl:text/>). (if (@codeSystem and doc-available(concat('../vocab/',@codeSystem,'.xml')) and ( document(concat('../vocab/',@codeSystem,'.xml'))/*[@codeStrength='CNE'] or not(document(concat('../vocab/',@codeSystem,'.xml'))/*/@codeStrength))) then ( not(document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:code[@code=$code]) ) else ( 0=1 ) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no originalText on translations (not(hl7:translation/hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no translation on translations (not(hl7:translation/hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no null on translations (not(hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@code)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation code requires codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation codeSystemName only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation codeSystemVersion only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@code or not(hl7:translation/@displayName)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation displayName only if code (hl7:translation/@code or not(hl7:translation/@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="self::hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(../hl7:id/@root='2.16.528.1.1007.3.1') or          document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: UZI rolcode attribuut code moet een geldige RoleCodeNL bevatten (not(../hl7:id/@root='2.16.528.1.1007.3.1') or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="self::hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or not(../hl7:id/@root='2.16.528.1.1007.3.3') or          document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: organisatie rolcode attribuut code moet een geldige AssignedRoleType bevatten (@nullFlavor or not(../hl7:id/@root='2.16.528.1.1007.3.3') or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CE: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CV: cannot have translation (not(hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:authorOrPerformer/hl7:participant/hl7:AssignedDevice/hl7:Organization/hl7:name"
                 priority="1018"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-EN: entity name shall be null or text only or element only (no mixed content) (@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="*[not(@nullFlavor)][normalize-space(.)='']">
         <xsl:message>dtr1-3-EN: empty name particles should not be present. (*[not(@nullFlavor)][normalize-space(.)=''] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="substring(normalize-space(.),1,1)='&#34;'">
         <xsl:message>dtr1-4-EN: Use of quotes at the beginning of a name are probably not correct. (substring(normalize-space(.),1,1)='"' / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(hl7:family)=0 and count(hl7:given)=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ON: no parts may be person name type particles (count(hl7:family)=0 and count(hl7:given)=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(*)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-ON: organization names SHALL be element content (not(*) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:overseer"
                 priority="1016"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@typeCode='RESP'"/>
         <xsl:otherwise>
            <xsl:message>Control Act: overseer/@typeCode moet RESP zijn (@typeCode='RESP' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:overseer/hl7:noteText"
                 priority="1015"
                 mode="M5">

		<!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/<xsl:text/>
               <xsl:value-of select="local-name()"/>
               <xsl:text/> niet gebruiken (false() / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:overseer/hl7:time"
                 priority="1014"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-QTY: no uncertainty (not(hl7:uncertainty/@expression) and not(hl7:uncertainty/@uncertainty) and not(hl7:uncertainty/@originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-QTY: no history or updateMode (count(*[self::hl7:originalText or self::hl7:uncertainty or self::hl7:expression][@validTimeLow or @validTimeHigh or @updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@nullFlavor and not(@value|@unit|*)) or (not(@nullFlavor) and (@value|@unit|hl7:low|hl7:center|hl7:high|hl7:width))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-IVL: null violation. Cannot have @nullFlavor and @value or child elements, or the other way around ((@nullFlavor and not(@value|@unit|*)) or (not(@nullFlavor) and (@value|@unit|hl7:low|hl7:center|hl7:high|hl7:width)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(*[@nullFlavor and (@value|@unit)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-IVL: null violation. Cannot have @nullFlavor and @value on any child elements (not(*[@nullFlavor and (@value|@unit)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:*[@nullFlavor and (@value|@unit)])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-IVL: null violation. Child element has @nullFlavor and @value (not(hl7:*[@nullFlavor and (@value|@unit)]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="         @nullFlavor or         (not(@nullFlavor) and @value and not(*)) or         (not(@nullFlavor) and not(@value) and (hl7:low|hl7:center|hl7:high|hl7:width)) or         (not(@nullFlavor) and not(@value) and (hl7:*[not(@nullFlavor)])) or         (not(@nullFlavor) and not(@value) and hl7:center and not(hl7:low|hl7:high|hl7:width)) or         (not(@nullFlavor) and not(@value) and not(hl7:center) and hl7:width and not(hl7:low and hl7:high))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-IVL: co-occurence violation. Cannot have @value and other child elements, or missing @value and child elements with data, or center element with other elements, or width element with
        both low and high elements (@nullFlavor or (not(@nullFlavor) and @value and not(*)) or (not(@nullFlavor) and not(@value) and (hl7:low|hl7:center|hl7:high|hl7:width)) or (not(@nullFlavor) and not(@value) and (hl7:*[not(@nullFlavor)])) or (not(@nullFlavor) and not(@value) and hl7:center and not(hl7:low|hl7:high|hl7:width)) or (not(@nullFlavor) and not(@value) and not(hl7:center) and hl7:width and not(hl7:low and hl7:high)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(*[@updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-IVL: no updateMode on IVL attributes (count(*[@updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:low/@value and hl7:high/@value) or hl7:low/@value != hl7:high/@value"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-IVL: low/@value must not be equal to high/@value (not(hl7:low/@value and hl7:high/@value) or hl7:low/@value != hl7:high/@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:width) or         hl7:width[not(@unit)] or         hl7:width[@value and @unit]"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-PQR: width element: no unit without value (not(hl7:width) or hl7:width[not(@unit)] or hl7:width[@value and @unit] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:width/hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-PQR: width element: no translation (not(hl7:width/hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:low/@value and hl7:high/@value) or string-length(hl7:low/@value) = string-length(hl7:high/@value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-IVL_TS: low/@value must have the same precision as
        high/@value (not(hl7:low/@value and hl7:high/@value) or string-length(hl7:low/@value) = string-length(hl7:high/@value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:low/@value and hl7:high/@value) or         number(substring(concat(hl7:low/@value,'00000000000000'),1,14)) &lt; number(substring(concat(hl7:high/@value,'00000000000000'),1,14))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-IVL_TS: low/@value must be before high/@value (not(hl7:low/@value and hl7:high/@value) or number(substring(concat(hl7:low/@value,'00000000000000'),1,14)) &lt; number(substring(concat(hl7:high/@value,'00000000000000'),1,14)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="tum" select="'^(us|ms|s|min|h|d|wk|mo|a|)$'"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="matches(hl7:width/@unit, $tum)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-IVL_TS: for width only us (microseconds), ms (milliseconds), s (seconds), min (minute), h (hours), d (day), wk (week),
        mo (month) or a (year) are allowed (matches(hl7:width/@unit, $tum) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:overseer/hl7:modeCode"
                 priority="1013"
                 mode="M5">

		<!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/<xsl:text/>
               <xsl:value-of select="local-name()"/>
               <xsl:text/> niet gebruiken (false() / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:overseer/hl7:signatureCode"
                 priority="1012"
                 mode="M5">

		<!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/<xsl:text/>
               <xsl:value-of select="local-name()"/>
               <xsl:text/> niet gebruiken (false() / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:overseer/hl7:signatureText"
                 priority="1011"
                 mode="M5">

		<!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="false()"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/<xsl:text/>
               <xsl:value-of select="local-name()"/>
               <xsl:text/> niet gebruiken (false() / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:overseer//hl7:*[local-name()='AssignedPerson' or local-name()='assignedEntity']"
                 priority="1009"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:id[@root='2.16.528.1.1007.3.1' or @root='2.16.840.1.113883.2.4.6.3']"/>
         <xsl:otherwise>
            <xsl:message>Control Act: overseer/*/<xsl:text/>
               <xsl:value-of select="local-name(.)"/>
               <xsl:text/>/id. Tenminste één id moet als root 2.16.528.1.1007.3.1 (UZI), 2.16.840.1.113883.2.4.6.3 (BSN) hebben (hl7:id[@root='2.16.528.1.1007.3.1' or @root='2.16.840.1.113883.2.4.6.3'] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:code"/>
         <xsl:otherwise>
            <xsl:message>Control Act: overseer/*/<xsl:text/>
               <xsl:value-of select="local-name(.)"/>
               <xsl:text/>/code is verplicht (hl7:code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:id[@root='2.16.528.1.1007.3.1']) or hl7:assignedPrincipalChoiceList/hl7:assignedPerson/hl7:name"/>
         <xsl:otherwise>
            <xsl:message>Control Act: overseer/*/<xsl:text/>
               <xsl:value-of select="local-name(.)"/>
               <xsl:text/>/name is verplicht (not(hl7:id[@root='2.16.528.1.1007.3.1']) or hl7:assignedPrincipalChoiceList/hl7:assignedPerson/hl7:name / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:id[@root='2.16.528.1.1007.3.1']) or hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3' and @extension]"/>
         <xsl:otherwise>
            <xsl:message>Control Act: overseer/*/<xsl:text/>
               <xsl:value-of select="local-name(.)"/>
               <xsl:text/>/Organization/id moet de zorgaanbieder van de persoon identificeren (not(hl7:id[@root='2.16.528.1.1007.3.1']) or hl7:Organization/hl7:id[@root='2.16.528.1.1007.3.3' and @extension] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:id[@root='2.16.528.1.1007.3.1']) or hl7:Organization/hl7:name"/>
         <xsl:otherwise>
            <xsl:message>Control Act: overseer/*/<xsl:text/>
               <xsl:value-of select="local-name(.)"/>
               <xsl:text/>/Organization/name moet de zorgaanbiedernaam bevatten (not(hl7:id[@root='2.16.528.1.1007.3.1']) or hl7:Organization/hl7:name / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:id[@root='2.16.528.1.1007.3.1']) or hl7:Organization/hl7:addr/hl7:city"/>
         <xsl:otherwise>
            <xsl:message>Control Act: overseer/*/<xsl:text/>
               <xsl:value-of select="local-name(.)"/>
               <xsl:text/>/Organization/addr moet tennminste de vestigingsplaats bevatten (not(hl7:id[@root='2.16.528.1.1007.3.1']) or hl7:Organization/hl7:addr/hl7:city / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:overseer//hl7:*[local-name()='AssignedPerson' or local-name()='assignedEntity']/hl7:id"
                 priority="1008"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn (not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: AGB-code moet 8 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef (not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue" select="@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: @extension moet een geldige interactie-id bevatten (not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@root='2.16.528.1.1007.3.1' or @root='2.16.840.1.113883.2.4.6.3' or @root='2.16.840.1.113883.2.4.6.1'"/>
         <xsl:otherwise>
            <xsl:message>Control Act: overseer//<xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/id. @root moet 2.16.528.1.1007.3.1 (UZI), 2.16.840.1.113883.2.4.6.3 (BSN), of  or 2.16.840.1.113883.2.4.6.1 (AGB) zijn (@root='2.16.528.1.1007.3.1' or @root='2.16.840.1.113883.2.4.6.3' or @root='2.16.840.1.113883.2.4.6.1' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or              following-sibling::hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.8'][@code='P'] or             following-sibling::hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.6']"/>
         <xsl:otherwise>
            <xsl:message>Control Act: overseer//<xsl:text/>
               <xsl:value-of select="local-name(..)"/>
               <xsl:text/>/code/@code moet "P" (Patiënt) zijn of een geldige waarde uit RoleCodeWettelijkeVertegenwoordigerNL (not(@root='2.16.840.1.113883.2.4.6.3') or following-sibling::hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.8'][@code='P'] or following-sibling::hl7:code[@codeSystem='2.16.840.1.113883.2.4.3.11.6'] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:overseer//hl7:*[local-name()='AssignedPerson' or local-name()='assignedEntity']/hl7:code"
                 priority="1007"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@code or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@code))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CD: no code if null (not(@nullFlavor) or (@nullFlavor and not(@code)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CD: no displayName if null (not(@nullFlavor) or (@nullFlavor and not(@displayName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CD: no originalText on translations (not(hl7:translation/hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-CD: no null on translations (not(hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-11-CD: translation code requires codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@code or not(hl7:translation/@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-14-CD: translation displayName only if code (hl7:translation/@code or not(hl7:translation/@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="matches(@displayName,'[\r\n\t]')">
         <xsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to
        interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="code" select="@code"/>

		    <!--REPORT warning-->
<xsl:if test="@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))">
         <xsl:message>Datatype CD: waarschuwing: onbekend codeSystem '<xsl:text/>
            <xsl:value-of select="@codeSystem"/>
            <xsl:text/>' gevonden met codeSystemName 
        '<xsl:text/>
            <xsl:value-of select="./@codeSystemName"/>
            <xsl:text/>'. Bestand '<xsl:text/>
            <xsl:value-of select="concat('../vocab/',@codeSystem,'.xml')"/>
            <xsl:text/>' ontbreekt. (@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml'))) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="hl7:translation[@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))]">
         <xsl:message>Datatype CD: waarschuwing: onbekend codeSystem '<xsl:text/>
            <xsl:value-of select="hl7:translation/@codeSystem"/>
            <xsl:text/>' in translation (hl7:translation[@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="if (@codeSystem and doc-available(concat('../vocab/',@codeSystem,'.xml')) and (         document(concat('../vocab/',@codeSystem,'.xml'))/*[@codeStrength='CNE'] or         not(document(concat('../vocab/',@codeSystem,'.xml'))/*/@codeStrength))) then (          not(document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:code[@code=$code]) ) else ( 0=1 )">
         <xsl:message>Datatype CD: waarschuwing: onbekende code '<xsl:text/>
            <xsl:value-of select="$code"/>
            <xsl:text/>' gevonden in codeSystem '<xsl:text/>
            <xsl:value-of select="@codeSystem"/>
            <xsl:text/>'
        gevonden met displayName '<xsl:text/>
            <xsl:value-of select="./@displayName"/>
            <xsl:text/>'. Waarde ontbreekt in 
        '<xsl:text/>
            <xsl:value-of select="concat('../vocab/',@codeSystem,'.xml')"/>
            <xsl:text/>' (<xsl:text/>
            <xsl:value-of select="document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:name"/>
            <xsl:text/>). (if (@codeSystem and doc-available(concat('../vocab/',@codeSystem,'.xml')) and ( document(concat('../vocab/',@codeSystem,'.xml'))/*[@codeStrength='CNE'] or not(document(concat('../vocab/',@codeSystem,'.xml'))/*/@codeStrength))) then ( not(document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:code[@code=$code]) ) else ( 0=1 ) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no originalText on translations (not(hl7:translation/hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no translation on translations (not(hl7:translation/hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no null on translations (not(hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@code)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation code requires codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation codeSystemName only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation codeSystemVersion only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@code or not(hl7:translation/@displayName)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation displayName only if code (hl7:translation/@code or not(hl7:translation/@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="self::hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(../hl7:id/@root='2.16.528.1.1007.3.1') or          document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: UZI rolcode attribuut code moet een geldige RoleCodeNL bevatten (not(../hl7:id/@root='2.16.528.1.1007.3.1') or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="self::hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or not(../hl7:id/@root='2.16.528.1.1007.3.3') or          document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: organisatie rolcode attribuut code moet een geldige AssignedRoleType bevatten (@nullFlavor or not(../hl7:id/@root='2.16.528.1.1007.3.3') or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CE: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:overseer//hl7:*[local-name()='AssignedPerson' or local-name()='assignedEntity']/hl7:telecom"
                 priority="1006"
                 mode="M5">
      <xsl:variable name="urlScheme" select="substring-before(@value,':')"/>
      <xsl:variable name="urlStr" select="substring-after(@value,':')"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-URL: elements of type URL SHALL have a @value attribute. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value=iri-to-uri(@value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-URL: @value must be a valid URI, e.g. '<xsl:text/>
               <xsl:value-of select="iri-to-uri(@value)"/>
               <xsl:text/>'. (@value=iri-to-uri(@value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: Telecom elementen moeten een value attribuut hebben. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value=iri-to-uri(@value)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: Een telecom value moet een geldige URI zijn, bijvoorbeeld '<xsl:text/>
               <xsl:value-of select="iri-to-uri(@value)"/>
               <xsl:text/>'. (@value=iri-to-uri(@value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="urlScheme" select="substring-before(@value,':')"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value and document('../vocab/URL-urlScheme.xml')/*/hl7:code[@code=$urlScheme]"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: Telecom value moet een in Nederland geldig URL scheme hebben. Gevonden '<xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/>' (@value and document('../vocab/URL-urlScheme.xml')/*/hl7:code[@code=$urlScheme] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="urlStr" select="substring-after(@value,':')"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='tel' or $urlScheme='fax') then (         matches($urlStr,'^(\+?([\d()./-]|(%[a-f\d]{2}))+)*(;(phone-context=((\+?([\d()./-]|(%[a-f\d]{2}))+)|(([a-z\d-]|(%[a-f\d]{2}))+(\.([a-z\d-]|(%[a-f\d]{2}))+)*))|(ext=[\d./-]+)|(isub=(([a-z\d();/?:@&amp;=+$,_.!~*-])|(%[a-f\d]{2}))+)|([a-z\d-]+=([a-z\d\[\]/:&amp;+$_.!~*()-]|(%[a-f\d]{2}))+)))*$')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 3966 (if ($urlScheme='tel' or $urlScheme='fax') then ( matches($urlStr,'^(\+?([\d()./-]|(%[a-f\d]{2}))+)*(;(phone-context=((\+?([\d()./-]|(%[a-f\d]{2}))+)|(([a-z\d-]|(%[a-f\d]{2}))+(\.([a-z\d-]|(%[a-f\d]{2}))+)*))|(ext=[\d./-]+)|(isub=(([a-z\d();/?:@&amp;=+$,_.!~*-])|(%[a-f\d]{2}))+)|([a-z\d-]+=([a-z\d\[\]/:&amp;+$_.!~*()-]|(%[a-f\d]{2}))+)))*$') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc3966)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='file') then (         matches($urlStr,'^///{0,2}((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 1738. (if ($urlScheme='file') then ( matches($urlStr,'^///{0,2}((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc1738)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='nfs') then (         matches($urlStr,'^//((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))/?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 2224. (if ($urlScheme='nfs') then ( matches($urlStr,'^//((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))/?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc2224)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='ftp' or $urlScheme='ftps') then (         matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;=~_-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z][\w-]*))?)?(/(([a-z\d$\.+!*(),?&amp;_~=-])|(%[a-f\d]{2}))*)*(;type=[aid])?$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 1738. (if ($urlScheme='ftp' or $urlScheme='ftps') then ( matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;=~_-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z][\w-]*))?)?(/(([a-z\d$\.+!*(),?&amp;_~=-])|(%[a-f\d]{2}))*)*(;type=[aid])?$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc1738)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='http' or $urlScheme='https') then (         matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*(\?(([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*(&amp;((([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*)?)*)?(#([\w~!$+|.,*:=~_]|%[a-f\d]{2})*)?$', 'i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 1738 (if ($urlScheme='http' or $urlScheme='https') then ( matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*(\?(([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*(&amp;((([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*)?)*)?(#([\w~!$+|.,*:=~_]|%[a-f\d]{2})*)?$', 'i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc1738)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='telnet') then (         matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)*$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 1738. (if ($urlScheme='telnet') then ( matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)*$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc1738)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='mailto') then (         matches($urlStr,'^[\w$\.+!*(),?&amp;~_=-]+(\.[\w$\.+!*(),?&amp;~_=-]+)*@([\w$+!*(),?&amp;~_=-]+\.)+([a-z]{2,4})$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 2368. Merk op dat het niet toegestaan is extra headers op te nemen (if ($urlScheme='mailto') then ( matches($urlStr,'^[\w$\.+!*(),?&amp;~_=-]+(\.[\w$\.+!*(),?&amp;~_=-]+)*@([\w$+!*(),?&amp;~_=-]+\.)+([a-z]{2,4})$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc2368)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='x-hl7-applicatie') then (         matches($urlStr,'^2\.16\.840\.1\.113883\.2\.4\.6\.6\.[1-9]\d+$')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten beginnen met "2.16.840.1.113883.2.4.6.6." gevolgd door een numeriek deel (if ($urlScheme='x-hl7-applicatie') then ( matches($urlStr,'^2\.16\.840\.1\.113883\.2\.4\.6\.6\.[1-9]\d+$') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='mllp') then (         matches($urlStr,'^//(([1-2]\d{0,2})(\.([1-2]\d{0,2})){3}|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2}))):(([1-9]\d{0,4})|([A-Za-z]\w*))/$')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan mllp://host:port/ waarbij 'host' een naam of IP kan zijn en 'port' een benoemde poort of een nummer (if ($urlScheme='mllp') then ( matches($urlStr,'^//(([1-2]\d{0,2})(\.([1-2]\d{0,2})){3}|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2}))):(([1-9]\d{0,4})|([A-Za-z]\w*))/$') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor and hl7:usablePeriod)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-TEL: not null and usablePeriod (not(@nullFlavor and hl7:usablePeriod) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:overseer//hl7:*[local-name()='AssignedPerson' or local-name()='assignedEntity']/hl7:assignedPrincipalChoiceList/hl7:assignedPerson/hl7:name"
                 priority="1005"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-EN: entity name shall be null or text only or element only (no mixed content) (@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="*[not(@nullFlavor)][normalize-space(.)='']">
         <xsl:message>dtr1-3-EN: empty name particles should not be present. (*[not(@nullFlavor)][normalize-space(.)=''] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="substring(normalize-space(.),1,1)='&#34;'">
         <xsl:message>dtr1-4-EN: Use of quotes at the beginning of a name are probably not correct. (substring(normalize-space(.),1,1)='"' / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:given[contains(@qualifier,'IN')]) or hl7:given[contains(@qualifier,'IN') and not(starts-with(text(),'.')) and contains(text(),'.') and ends-with(text(),'.')]"/>
         <xsl:otherwise>
            <xsl:message>Datatype PN: als given/@qualifier 'IN' bevat dan moeten er initialen gescheiden en gevolgd door een punt in het element given staan. (not(hl7:given[contains(@qualifier,'IN')]) or hl7:given[contains(@qualifier,'IN') and not(starts-with(text(),'.')) and contains(text(),'.') and ends-with(text(),'.')] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:given[contains(@qualifier,'IN') and contains(@qualifier,'CL')])"/>
         <xsl:otherwise>
            <xsl:message>Datatype PN: given/@qualifier 'IN' en 'CL' gaan niet samen. Initalen zijn geen roepnaam (not(hl7:given[contains(@qualifier,'IN') and contains(@qualifier,'CL')]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:given[contains(@qualifier,'CL') and contains(text(),'.')])"/>
         <xsl:otherwise>
            <xsl:message>Datatype PN: als given/@qualifier 'CL' bevat dan moeten er voornamen in dit element staan. Voornamen hebben geen puntjes. (not(hl7:given[contains(@qualifier,'CL') and contains(text(),'.')]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="hl7:prefix[@qualifier='VV' and not(ends-with(text(),' '))]">
         <xsl:message>Datatype PN: als er een spatie tussen een voorvoegsel en de bijbehorende achternaam hoort, moet het prefix element met qualifier=VV ook eindigen met een spatie. (hl7:prefix[@qualifier='VV' and not(ends-with(text(),' '))] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="hl7:family[substring(.,1,4)='van '] or hl7:family[substring(.,1,3)='de ']">
         <xsl:message>Datatype PN: voorvoegsels moeten in het prefix element worden gevoerd, tenzij het bronsysteem voorvoegsels en achternaam niet gescheiden vastlegt. (hl7:family[substring(.,1,4)='van '] or hl7:family[substring(.,1,3)='de '] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:overseer//hl7:*[local-name()='AssignedPerson' or local-name()='assignedEntity']/hl7:Organization/hl7:id"
                 priority="1004"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn (not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: AGB-code moet 8 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef (not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue" select="@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: @extension moet een geldige interactie-id bevatten (not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="overseerRoot" select="@root"/>
      <xsl:variable name="overseerExt" select="@extension"/>
      <xsl:variable name="authorExt"
                    select="ancestor::hl7:*[hl7:authorOrPerformer]/hl7:authorOrPerformer//hl7:Organization/hl7:id[@root=$overseerRoot]/@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or $authorExt=$overseerExt or ancestor::hl7:*[hl7:authorOrPerformer]/hl7:authorOrPerformer//hl7:AssignedDevice"/>
         <xsl:otherwise>
            <xsl:message>Control Act: overseer//<xsl:text/>
               <xsl:value-of select="local-name(../..)"/>
               <xsl:text/>/Organization/id. Organisatie van de overseer (<xsl:text/>
               <xsl:value-of select="$overseerRoot"/>
               <xsl:text/>#<xsl:text/>
               <xsl:value-of select="$overseerExt"/>
               <xsl:text/>) moet gelijk zijn aan die van de authorOrPerformer (<xsl:text/>
               <xsl:value-of select="$authorExt"/>
               <xsl:text/>) (@nullFlavor or $authorExt=$overseerExt or ancestor::hl7:*[hl7:authorOrPerformer]/hl7:authorOrPerformer//hl7:AssignedDevice / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:overseer//hl7:*[local-name()='AssignedPerson' or local-name()='assignedEntity']/hl7:Organization/hl7:code"
                 priority="1003"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@code or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@code))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CD: no code if null (not(@nullFlavor) or (@nullFlavor and not(@code)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CD: no displayName if null (not(@nullFlavor) or (@nullFlavor and not(@displayName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CD: no originalText on translations (not(hl7:translation/hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-CD: no null on translations (not(hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-11-CD: translation code requires codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@code or not(hl7:translation/@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-14-CD: translation displayName only if code (hl7:translation/@code or not(hl7:translation/@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="matches(@displayName,'[\r\n\t]')">
         <xsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to
        interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="code" select="@code"/>

		    <!--REPORT warning-->
<xsl:if test="@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))">
         <xsl:message>Datatype CD: waarschuwing: onbekend codeSystem '<xsl:text/>
            <xsl:value-of select="@codeSystem"/>
            <xsl:text/>' gevonden met codeSystemName 
        '<xsl:text/>
            <xsl:value-of select="./@codeSystemName"/>
            <xsl:text/>'. Bestand '<xsl:text/>
            <xsl:value-of select="concat('../vocab/',@codeSystem,'.xml')"/>
            <xsl:text/>' ontbreekt. (@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml'))) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="hl7:translation[@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))]">
         <xsl:message>Datatype CD: waarschuwing: onbekend codeSystem '<xsl:text/>
            <xsl:value-of select="hl7:translation/@codeSystem"/>
            <xsl:text/>' in translation (hl7:translation[@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="if (@codeSystem and doc-available(concat('../vocab/',@codeSystem,'.xml')) and (         document(concat('../vocab/',@codeSystem,'.xml'))/*[@codeStrength='CNE'] or         not(document(concat('../vocab/',@codeSystem,'.xml'))/*/@codeStrength))) then (          not(document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:code[@code=$code]) ) else ( 0=1 )">
         <xsl:message>Datatype CD: waarschuwing: onbekende code '<xsl:text/>
            <xsl:value-of select="$code"/>
            <xsl:text/>' gevonden in codeSystem '<xsl:text/>
            <xsl:value-of select="@codeSystem"/>
            <xsl:text/>'
        gevonden met displayName '<xsl:text/>
            <xsl:value-of select="./@displayName"/>
            <xsl:text/>'. Waarde ontbreekt in 
        '<xsl:text/>
            <xsl:value-of select="concat('../vocab/',@codeSystem,'.xml')"/>
            <xsl:text/>' (<xsl:text/>
            <xsl:value-of select="document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:name"/>
            <xsl:text/>). (if (@codeSystem and doc-available(concat('../vocab/',@codeSystem,'.xml')) and ( document(concat('../vocab/',@codeSystem,'.xml'))/*[@codeStrength='CNE'] or not(document(concat('../vocab/',@codeSystem,'.xml'))/*/@codeStrength))) then ( not(document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:code[@code=$code]) ) else ( 0=1 ) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no originalText on translations (not(hl7:translation/hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no translation on translations (not(hl7:translation/hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no null on translations (not(hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@code)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation code requires codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation codeSystemName only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation codeSystemVersion only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@code or not(hl7:translation/@displayName)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation displayName only if code (hl7:translation/@code or not(hl7:translation/@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="self::hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(../hl7:id/@root='2.16.528.1.1007.3.1') or          document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: UZI rolcode attribuut code moet een geldige RoleCodeNL bevatten (not(../hl7:id/@root='2.16.528.1.1007.3.1') or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="self::hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or not(../hl7:id/@root='2.16.528.1.1007.3.3') or          document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: organisatie rolcode attribuut code moet een geldige AssignedRoleType bevatten (@nullFlavor or not(../hl7:id/@root='2.16.528.1.1007.3.3') or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CE: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:overseer//hl7:*[local-name()='AssignedPerson' or local-name()='assignedEntity']/hl7:Organization/hl7:telecom"
                 priority="1002"
                 mode="M5">
      <xsl:variable name="urlScheme" select="substring-before(@value,':')"/>
      <xsl:variable name="urlStr" select="substring-after(@value,':')"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-URL: elements of type URL SHALL have a @value attribute. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value=iri-to-uri(@value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-URL: @value must be a valid URI, e.g. '<xsl:text/>
               <xsl:value-of select="iri-to-uri(@value)"/>
               <xsl:text/>'. (@value=iri-to-uri(@value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: Telecom elementen moeten een value attribuut hebben. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value=iri-to-uri(@value)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: Een telecom value moet een geldige URI zijn, bijvoorbeeld '<xsl:text/>
               <xsl:value-of select="iri-to-uri(@value)"/>
               <xsl:text/>'. (@value=iri-to-uri(@value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="urlScheme" select="substring-before(@value,':')"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@value and document('../vocab/URL-urlScheme.xml')/*/hl7:code[@code=$urlScheme]"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: Telecom value moet een in Nederland geldig URL scheme hebben. Gevonden '<xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/>' (@value and document('../vocab/URL-urlScheme.xml')/*/hl7:code[@code=$urlScheme] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="urlStr" select="substring-after(@value,':')"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='tel' or $urlScheme='fax') then (         matches($urlStr,'^(\+?([\d()./-]|(%[a-f\d]{2}))+)*(;(phone-context=((\+?([\d()./-]|(%[a-f\d]{2}))+)|(([a-z\d-]|(%[a-f\d]{2}))+(\.([a-z\d-]|(%[a-f\d]{2}))+)*))|(ext=[\d./-]+)|(isub=(([a-z\d();/?:@&amp;=+$,_.!~*-])|(%[a-f\d]{2}))+)|([a-z\d-]+=([a-z\d\[\]/:&amp;+$_.!~*()-]|(%[a-f\d]{2}))+)))*$')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 3966 (if ($urlScheme='tel' or $urlScheme='fax') then ( matches($urlStr,'^(\+?([\d()./-]|(%[a-f\d]{2}))+)*(;(phone-context=((\+?([\d()./-]|(%[a-f\d]{2}))+)|(([a-z\d-]|(%[a-f\d]{2}))+(\.([a-z\d-]|(%[a-f\d]{2}))+)*))|(ext=[\d./-]+)|(isub=(([a-z\d();/?:@&amp;=+$,_.!~*-])|(%[a-f\d]{2}))+)|([a-z\d-]+=([a-z\d\[\]/:&amp;+$_.!~*()-]|(%[a-f\d]{2}))+)))*$') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc3966)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='file') then (         matches($urlStr,'^///{0,2}((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 1738. (if ($urlScheme='file') then ( matches($urlStr,'^///{0,2}((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc1738)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='nfs') then (         matches($urlStr,'^//((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))/?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 2224. (if ($urlScheme='nfs') then ( matches($urlStr,'^//((((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+([a-z]+))))|([a-z][:|]))/?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc2224)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='ftp' or $urlScheme='ftps') then (         matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;=~_-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z][\w-]*))?)?(/(([a-z\d$\.+!*(),?&amp;_~=-])|(%[a-f\d]{2}))*)*(;type=[aid])?$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 1738. (if ($urlScheme='ftp' or $urlScheme='ftps') then ( matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;=~_-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z][\w-]*))?)?(/(([a-z\d$\.+!*(),?&amp;_~=-])|(%[a-f\d]{2}))*)*(;type=[aid])?$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc1738)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='http' or $urlScheme='https') then (         matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*(\?(([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*(&amp;((([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*)?)*)?(#([\w~!$+|.,*:=~_]|%[a-f\d]{2})*)?$', 'i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 1738 (if ($urlScheme='http' or $urlScheme='https') then ( matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))*)*(\?(([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*(&amp;((([\w$_\.+;:@~!*(),])|(%[a-f\d]{2}))+=(([\w$_\.+;:/@~!*(),-])|(%[a-f\d]{2}))*)?)*)?(#([\w~!$+|.,*:=~_]|%[a-f\d]{2})*)?$', 'i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc1738)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='telnet') then (         matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)*$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 1738. (if ($urlScheme='telnet') then ( matches($urlStr,'^//((([a-z\d$\.+!*(),?&amp;~_=-])|(%[a-f\d]{2}))+(:(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)?@)?((([1-2]\d{0,2})(\.([1-2]\d{0,2})){3})|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2})))(:(([1-9]\d{0,4})|([a-z]\w*))?)?(/(([a-z\d$\.+!*(),?&amp;=-])|(%[a-f\d]{2}))*)*$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc1738)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='mailto') then (         matches($urlStr,'^[\w$\.+!*(),?&amp;~_=-]+(\.[\w$\.+!*(),?&amp;~_=-]+)*@([\w$+!*(),?&amp;~_=-]+\.)+([a-z]{2,4})$','i')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan RFC 2368. Merk op dat het niet toegestaan is extra headers op te nemen (if ($urlScheme='mailto') then ( matches($urlStr,'^[\w$\.+!*(),?&amp;~_=-]+(\.[\w$\.+!*(),?&amp;~_=-]+)*@([\w$+!*(),?&amp;~_=-]+\.)+([a-z]{2,4})$','i') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / http://tools.ietf.org/html/rfc2368)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='x-hl7-applicatie') then (         matches($urlStr,'^2\.16\.840\.1\.113883\.2\.4\.6\.6\.[1-9]\d+$')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten beginnen met "2.16.840.1.113883.2.4.6.6." gevolgd door een numeriek deel (if ($urlScheme='x-hl7-applicatie') then ( matches($urlStr,'^2\.16\.840\.1\.113883\.2\.4\.6\.6\.[1-9]\d+$') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if ($urlScheme='mllp') then (         matches($urlStr,'^//(([1-2]\d{0,2})(\.([1-2]\d{0,2})){3}|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2}))):(([1-9]\d{0,4})|([A-Za-z]\w*))/$')         ) else (1=1)"/>
         <xsl:otherwise>
            <xsl:message>Datatype URL: URI's met URL Scheme <xsl:text/>
               <xsl:value-of select="$urlScheme"/>
               <xsl:text/> moeten voldoen aan mllp://host:port/ waarbij 'host' een naam of IP kan zijn en 'port' een benoemde poort of een nummer (if ($urlScheme='mllp') then ( matches($urlStr,'^//(([1-2]\d{0,2})(\.([1-2]\d{0,2})){3}|(([\w-]+\.)+(aero|arpa|asia|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|tel|travel|[a-z]{2}))):(([1-9]\d{0,4})|([A-Za-z]\w*))/$') ) else (1=1) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor and hl7:usablePeriod)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-TEL: not null and usablePeriod (not(@nullFlavor and hl7:usablePeriod) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:overseer//hl7:*[local-name()='AssignedPerson' or local-name()='assignedEntity']/hl7:Organization/hl7:name"
                 priority="1001"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-EN: entity name shall be null or text only or element only (no mixed content) (@nullFlavor or (count(*)&gt;0 and string-length(normalize-space(string-join(text(),'')))=0) or (count(*)=0 and string-length(normalize-space(string-join(text(),'')))&gt;0) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="*[not(@nullFlavor)][normalize-space(.)='']">
         <xsl:message>dtr1-3-EN: empty name particles should not be present. (*[not(@nullFlavor)][normalize-space(.)=''] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="substring(normalize-space(.),1,1)='&#34;'">
         <xsl:message>dtr1-4-EN: Use of quotes at the beginning of a name are probably not correct. (substring(normalize-space(.),1,1)='"' / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(hl7:family)=0 and count(hl7:given)=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-ON: no parts may be person name type particles (count(hl7:family)=0 and count(hl7:given)=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(*)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-ON: organization names SHALL be element content (not(*) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:ControlActProcess/hl7:overseer//hl7:*[local-name()='AssignedPerson' or local-name()='assignedEntity']/hl7:Organization/hl7:addr"
                 priority="1000"
                 mode="M5">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (count(*)&gt;0 and not(text()[string-length(normalize-space())&gt;0])) or (count(*)=0 and text()[string-length(normalize-space())&gt;0])"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-AD: address shall be null or text only or element only (no mixed content) (@nullFlavor or (count(*)&gt;0 and not(text()[string-length(normalize-space())&gt;0])) or (count(*)=0 and text()[string-length(normalize-space())&gt;0]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:useablePeriod/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-AD: no useablePeriod if null (not(@nullFlavor) or (not(hl7:thumbnail) or hl7:useablePeriod/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(*[self::hl7:useablePeriod][@updateMode])=0"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-AD: updateMode shall not be used on address elements (count(*[self::hl7:useablePeriod][@updateMode])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or          string-length(hl7:useablePeriod/hl7:low/@value) = string-length(hl7:useablePeriod/hl7:high/@value)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-AD: useablePeriod/low/@value must have the same precision as useablePeriod/high/@value (not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or string-length(hl7:useablePeriod/hl7:low/@value) = string-length(hl7:useablePeriod/hl7:high/@value) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or         number(substring(concat(hl7:useablePeriod/hl7:low/@value,'00000000000000'),1,14)) &lt; number(substring(concat(hl7:useablePeriod/hl7:high/@value,'00000000000000'),1,14))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-AD: useablePeriod/low/@value must be before useablePeriod/high/@value (not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or number(substring(concat(hl7:useablePeriod/hl7:low/@value,'00000000000000'),1,14)) &lt; number(substring(concat(hl7:useablePeriod/hl7:high/@value,'00000000000000'),1,14)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="tum" select="'^(us|ms|s|min|h|d|wk|mo|a|)$'"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="matches(hl7:useablePeriod/hl7:width/@unit, $tum)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-AD: for useablePeriod/width only us (microseconds), ms (milliseconds), s (seconds), min (minute), h (hours), d (day), wk (week), mo (month) or a (year) are allowed (matches(hl7:useablePeriod/hl7:width/@unit, $tum) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="postalCodeText" select="hl7:postalCode/text()"/>
      <xsl:variable name="countryCode" select="hl7:country/@code"/>
      <xsl:variable name="countryCodeSystem" select="hl7:country/@codeSystem"/>
      <xsl:variable name="countryText" select="upper-case(normalize-space(hl7:country))"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if (@codeSystem='2.16.840.1.113883.2.4.4.15') then (         matches(@code,'^[0-9]{4}[A-Z]{2}$')         ) else ( 1=1 )"/>
         <xsl:otherwise>
            <xsl:message>Datatype AD: postcodes onder codeSystem '2.16.840.1.113883.2.4.4.15' moeten voldoen aan '9999AA' (if (@codeSystem='2.16.840.1.113883.2.4.4.15') then ( matches(@code,'^[0-9]{4}[A-Z]{2}$') ) else ( 1=1 ) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:additionalLocator/text()=('to','by') or not(matches(hl7:postalCode/text(),'^[0-9]{4} [A-Z]{2}$')) or not(hl7:additionalLocator)"/>
         <xsl:otherwise>
            <xsl:message>Datatype AD: In een Nederlands adres kan additionalLocator alleen de waarden 'to' of 'by' bevatten (hl7:additionalLocator/text()=('to','by') or not(matches(hl7:postalCode/text(),'^[0-9]{4} [A-Z]{2}$')) or not(hl7:additionalLocator) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="if (hl7:postalCode/text() and (not(hl7:country) or          ($countryCode='NL' and ($countryCodeSystem='2.16.1' or $countryCodeSystem='1.3.6.1.4.1.1466.115.121.1.11' or $countryCodeSystem='1.0.3166.1.2.2')) or         ($countryCode='NLD' and $countryCodeSystem='2.16.2') or         ($countryCode='528' and $countryCodeSystem='2.16.3') or         $countryText='NL' or         $countryText='NLD' or         $countryText='NEDERLAND'         )) then ( matches($postalCodeText,'^[0-9]{4} [A-Z]{2}$')         ) else ( 1=1 )"/>
         <xsl:otherwise>
            <xsl:message>Datatype AD: Nederlandse postcodes in de text-nodes moeten voldoen aan '9999 AA' (if (hl7:postalCode/text() and (not(hl7:country) or ($countryCode='NL' and ($countryCodeSystem='2.16.1' or $countryCodeSystem='1.3.6.1.4.1.1466.115.121.1.11' or $countryCodeSystem='1.0.3166.1.2.2')) or ($countryCode='NLD' and $countryCodeSystem='2.16.2') or ($countryCode='528' and $countryCodeSystem='2.16.3') or $countryText='NL' or $countryText='NLD' or $countryText='NEDERLAND' )) then ( matches($postalCodeText,'^[0-9]{4} [A-Z]{2}$') ) else ( 1=1 ) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="illegalAddressPart"
                    select="*[local-name(.)!='delimiter' and local-name(.)!='buildingNumberSuffix' and         local-name(.)!='country' and local-name(.)!='county' and         local-name(.)!='city' and local-name(.)!='postalCode' and         local-name(.)!='houseNumber' and local-name(.)!='streetName' and         local-name(.)!='additionalLocator'][1]/name()"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(*)=0 or string-length($illegalAddressPart)=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype AD: binnen Nederland mogen alleen delimiter, country, county, 
        city, postalCode, houseNumber, buildingNumberSuffix, streetName en additionalLocator worden gebruikt. Gevonden '<xsl:text/>
               <xsl:value-of select="$illegalAddressPart"/>
               <xsl:text/>'. (count(*)=0 or string-length($illegalAddressPart)=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(*)=0 or count(*[not(self::hl7:postalCode) and not(self::hl7:country) and @code])=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype AD: alleen postalCode en country 
        kunnen gecodeerd worden. Gevonden '<xsl:text/>
               <xsl:value-of select="*[not(self::hl7:postalCode) and not(self::hl7:country) and @code][1]/name()"/>
               <xsl:text/>' (count(*)=0 or count(*[not(self::hl7:postalCode) and not(self::hl7:country) and @code])=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M5"/>
   <xsl:template match="@*|node()" priority="-2" mode="M5">
      <xsl:apply-templates select="*" mode="M5"/>
   </xsl:template>

   <!--PATTERN -->


	<!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:profileId" priority="1002" mode="M6">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn (not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: AGB-code moet 8 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef (not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue" select="@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: @extension moet een geldige interactie-id bevatten (not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@root='2.16.840.1.113883.2.4.3.11.1' and @extension='810'"/>
         <xsl:otherwise>
            <xsl:message>In de transmission wrapper moet het element profileId worden gevuld met de waarde '810' (@root='2.16.840.1.113883.2.4.3.11.1' and @extension='810' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M6"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:acceptAckCode" priority="1001" mode="M6">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CS: @code/@typeCode and @nullFlavor are mutually exclusive ((@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystem)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CS: cannot have codeSystem (not(@codeSystem) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CS: cannot have codeSystemName (not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CS: cannot have codeSystemVersion (not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CS: cannot have displayName (not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CS: cannot have originalText (not(hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CS: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CS: cannot have translation (not(hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@code='NE'"/>
         <xsl:otherwise>
            <xsl:message>In de transmission wrapper moet het veld acceptAckCode worden gevuld met waarde 'NE'. (@code='NE' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M6"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:attentionLine" priority="1000" mode="M6">

		<!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="not(.)"/>
         <xsl:otherwise>
            <xsl:message>Het gebruik van attentionLine wordt nog niet gespecificeerd in deze interactie. (not(.) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M6"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M6"/>
   <xsl:template match="@*|node()" priority="-2" mode="M6">
      <xsl:apply-templates select="*" mode="M6"/>
   </xsl:template>

   <!--PATTERN -->


	<!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:sender/hl7:device/hl7:id" priority="1001"
                 mode="M7">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn (not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: AGB-code moet 8 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef (not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue" select="@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: @extension moet een geldige interactie-id bevatten (not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@root='2.16.840.1.113883.2.4.6.6' and not(@extension='1')"/>
         <xsl:otherwise>
            <xsl:message>De zender van deze interactie moet een AORTA applicatie zijn, en kan niet de ZIM zijn (@root='2.16.840.1.113883.2.4.6.6' and not(@extension='1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:PRPM_IN907020NL02/hl7:receiver/hl7:device/hl7:id" priority="1000"
                 mode="M7">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn (not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: AGB-code moet 8 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef (not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue" select="@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: @extension moet een geldige interactie-id bevatten (not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@root='2.16.840.1.113883.2.4.6.6' and @extension='1'"/>
         <xsl:otherwise>
            <xsl:message>De ontvanger van deze interactie moet een AORTA applicatie zijn, en moet de ZIM zijn (@root='2.16.840.1.113883.2.4.6.6' and @extension='1' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M7"/>
   <xsl:template match="@*|node()" priority="-2" mode="M7">
      <xsl:apply-templates select="*" mode="M7"/>
   </xsl:template>

   <!--PATTERN queryByParameter-->


	<!--RULE -->
<xsl:template match="hl7:queryByParameter" priority="1007" mode="M8">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:assignedEntityId or hl7:interactionId or hl7:qualifiedApplicationRoleCode"/>
         <xsl:otherwise>
            <xsl:message>tenminste één van de parameters assignedEntityId, interactionId of qualifiedApplicationRoleCode moet een waarde bevatten (hl7:assignedEntityId or hl7:interactionId or hl7:qualifiedApplicationRoleCode / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M8"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:queryByParameter/hl7:responseModalityCode" priority="1006" mode="M8">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="(@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CS: @code/@typeCode and @nullFlavor are mutually exclusive ((@nullFlavor and not(@code or @typeCode)) or (not(@nullFlavor) and (@code or @typeCode)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystem)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CS: cannot have codeSystem (not(@codeSystem) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CS: cannot have codeSystemName (not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CS: cannot have codeSystemVersion (not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CS: cannot have displayName (not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CS: cannot have originalText (not(hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CS: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CS: cannot have translation (not(hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="@code='R'"/>
         <xsl:otherwise>
            <xsl:message>responseModalityCode moet vaste waarde 'R' hebben. (@code='R' / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M8"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:queryByParameter/hl7:assignedEntityId" priority="1005" mode="M8">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(hl7:value)=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>/value mag slechts één maal voorkomen. (count(hl7:value)=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M8"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:queryByParameter/hl7:assignedEntityId/hl7:value" priority="1004"
                 mode="M8">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn (not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: AGB-code moet 8 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef (not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue" select="@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: @extension moet een geldige interactie-id bevatten (not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT warning-->
<xsl:choose>
         <xsl:when test="@root='2.16.528.1.1007.3.3' or (@root='2.16.840.1.113883.2.4.3.11' and @extension='7') or @root='2.16.840.1.113883.2.4.3.11.25' or @root='2.16.840.1.113883.2.4.3.11.10'"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text/>
               <xsl:value-of select="name(..)"/>
               <xsl:text/>/<xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/> is onbekend (@root='<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' @extension='<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>'). Verwachte waarden zijn '2.16.528.1.1007.3.3' (URA), '2.16.840.1.113883.2.4.3.11' / '7' (Klantenloket), '2.16.840.1.113883.2.4.3.11.25' (GBO/GBP), '2.16.840.1.113883.2.4.3.11.10' (organisatiedelen) (@root='2.16.528.1.1007.3.3' or (@root='2.16.840.1.113883.2.4.3.11' and @extension='7') or @root='2.16.840.1.113883.2.4.3.11.25' or @root='2.16.840.1.113883.2.4.3.11.10' / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M8"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:queryByParameter/hl7:interactionId" priority="1003" mode="M8">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(hl7:value)=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>/value mag slechts één maal voorkomen. (count(hl7:value)=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M8"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:queryByParameter/hl7:interactionId/hl7:value" priority="1002"
                 mode="M8">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or (not(@nullFlavor) and @root)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-II: @root is required if @nullFlavor is not present (@nullFlavor or (not(@nullFlavor) and @root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@root))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-II: @root may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@root)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-II: @identifierName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@identifierName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayable))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-II: @displayable may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@displayable)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@reliability))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-II: @reliability may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@reliability)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present (not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@root) &lt;= 128)">
         <xsl:message>dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@root) &lt;= 128) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="not(string-length(@extension) &lt;= 64)">
         <xsl:message>dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient (not(string-length(@extension) &lt;= 64) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn (not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or             matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn (not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType. (string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: AGB-code moet 8 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer moet 9 cijfers lang zijn (not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.2.4.6.3') or (             (   number(substring(@extension,1,1))*9 )+             (   number(substring(@extension,2,1))*8 )+             (   number(substring(@extension,3,1))*7 )+             (   number(substring(@extension,4,1))*6 )+             (   number(substring(@extension,5,1))*5 )+             (   number(substring(@extension,6,1))*4 )+             (   number(substring(@extension,7,1))*3 )+             (   number(substring(@extension,8,1))*2 )+             (   number(substring(@extension,9,1))*-1) ) mod 11=0"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef (not(@root='2.16.840.1.113883.2.4.6.3') or ( ( number(substring(@extension,1,1))*9 )+ ( number(substring(@extension,2,1))*8 )+ ( number(substring(@extension,3,1))*7 )+ ( number(substring(@extension,4,1))*6 )+ ( number(substring(@extension,5,1))*5 )+ ( number(substring(@extension,6,1))*4 )+ ( number(substring(@extension,7,1))*3 )+ ( number(substring(@extension,8,1))*2 )+ ( number(substring(@extension,9,1))*-1) ) mod 11=0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue" select="@extension"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype II: @extension moet een geldige interactie-id bevatten (not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@root='2.16.840.1.113883.1.6'"/>
         <xsl:otherwise>
            <xsl:message>interactionId/value/@root '2.16.840.1.113883.1.6' bevatten (@root='2.16.840.1.113883.1.6' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M8"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:queryByParameter/hl7:qualifiedApplicationRoleCode" priority="1001"
                 mode="M8">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="count(hl7:value)=1"/>
         <xsl:otherwise>
            <xsl:message>
               <xsl:text/>
               <xsl:value-of select="name(.)"/>
               <xsl:text/>/value mag slechts één maal voorkomen. (count(hl7:value)=1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M8"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="hl7:queryByParameter/hl7:qualifiedApplicationRoleCode/hl7:value"
                 priority="1000"
                 mode="M8">

		<!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CD: null or code and/or originalText (@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-2-CD: code requires codeSystem (@codeSystem or not(@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-3-CD: codeSystemName only if codeSystem (@codeSystem or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem or not(@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-4-CD: codeSystemVersion only if codeSystem (@codeSystem or not(@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@code or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-5-CD: displayName only if code (@code or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@code))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-6-CD: no code if null (not(@nullFlavor) or (@nullFlavor and not(@code)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(@nullFlavor) or (@nullFlavor and not(@displayName))"/>
         <xsl:otherwise>
            <xsl:message>dtr1-7-CD: no displayName if null (not(@nullFlavor) or (@nullFlavor and not(@displayName)) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-8-CD: no originalText on translations (not(hl7:translation/hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-10-CD: no null on translations (not(hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@code)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-11-CD: translation code requires codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-12-CD: translation codeSystemName only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-13-CD: translation codeSystemVersion only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@code or not(hl7:translation/@displayName)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-14-CD: translation displayName only if code (hl7:translation/@code or not(hl7:translation/@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
<xsl:if test="matches(@displayName,'[\r\n\t]')">
         <xsl:message>dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to
        interoperability problems. (matches(@displayName,'[\r\n\t]') / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>
      <xsl:variable name="code" select="@code"/>

		    <!--REPORT warning-->
<xsl:if test="@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))">
         <xsl:message>Datatype CD: waarschuwing: onbekend codeSystem '<xsl:text/>
            <xsl:value-of select="@codeSystem"/>
            <xsl:text/>' gevonden met codeSystemName 
        '<xsl:text/>
            <xsl:value-of select="./@codeSystemName"/>
            <xsl:text/>'. Bestand '<xsl:text/>
            <xsl:value-of select="concat('../vocab/',@codeSystem,'.xml')"/>
            <xsl:text/>' ontbreekt. (@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml'))) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="hl7:translation[@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))]">
         <xsl:message>Datatype CD: waarschuwing: onbekend codeSystem '<xsl:text/>
            <xsl:value-of select="hl7:translation/@codeSystem"/>
            <xsl:text/>' in translation (hl7:translation[@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--REPORT warning-->
<xsl:if test="if (@codeSystem and doc-available(concat('../vocab/',@codeSystem,'.xml')) and (         document(concat('../vocab/',@codeSystem,'.xml'))/*[@codeStrength='CNE'] or         not(document(concat('../vocab/',@codeSystem,'.xml'))/*/@codeStrength))) then (          not(document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:code[@code=$code]) ) else ( 0=1 )">
         <xsl:message>Datatype CD: waarschuwing: onbekende code '<xsl:text/>
            <xsl:value-of select="$code"/>
            <xsl:text/>' gevonden in codeSystem '<xsl:text/>
            <xsl:value-of select="@codeSystem"/>
            <xsl:text/>'
        gevonden met displayName '<xsl:text/>
            <xsl:value-of select="./@displayName"/>
            <xsl:text/>'. Waarde ontbreekt in 
        '<xsl:text/>
            <xsl:value-of select="concat('../vocab/',@codeSystem,'.xml')"/>
            <xsl:text/>' (<xsl:text/>
            <xsl:value-of select="document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:name"/>
            <xsl:text/>). (if (@codeSystem and doc-available(concat('../vocab/',@codeSystem,'.xml')) and ( document(concat('../vocab/',@codeSystem,'.xml'))/*[@codeStrength='CNE'] or not(document(concat('../vocab/',@codeSystem,'.xml'))/*/@codeStrength))) then ( not(document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:code[@code=$code]) ) else ( 0=1 ) / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:originalText)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no originalText on translations (not(hl7:translation/hl7:originalText) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no translation on translations (not(hl7:translation/hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation/@nullFlavor)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: no null on translations (not(hl7:translation/@nullFlavor) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@code)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation code requires codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@code) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation codeSystemName only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation codeSystemVersion only if codeSystem (hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="hl7:translation/@code or not(hl7:translation/@displayName)"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: translation displayName only if code (hl7:translation/@code or not(hl7:translation/@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="self::hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(../hl7:id/@root='2.16.528.1.1007.3.1') or          document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: UZI rolcode attribuut code moet een geldige RoleCodeNL bevatten (not(../hl7:id/@root='2.16.528.1.1007.3.1') or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="codeValue"
                    select="self::hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@nullFlavor or not(../hl7:id/@root='2.16.528.1.1007.3.3') or          document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"/>
         <xsl:otherwise>
            <xsl:message>Datatype CD: organisatie rolcode attribuut code moet een geldige AssignedRoleType bevatten (@nullFlavor or not(../hl7:id/@root='2.16.528.1.1007.3.3') or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue] / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:qualifier)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CE: cannot have qualifier (not(hl7:qualifier) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="not(hl7:translation)"/>
         <xsl:otherwise>
            <xsl:message>dtr1-1-CV: cannot have translation (not(hl7:translation) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
<xsl:choose>
         <xsl:when test="@codeSystem='2.16.840.1.113883.2.4.3.11.3'"/>
         <xsl:otherwise>
            <xsl:message>qualifiedApplicationRoleCode/value/@codeSystem moet '2.16.840.1.113883.2.4.3.11.3' bevatten (@codeSystem='2.16.840.1.113883.2.4.3.11.3' / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/>)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M8"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M8"/>
   <xsl:template match="@*|node()" priority="-2" mode="M8">
      <xsl:apply-templates select="*" mode="M8"/>
   </xsl:template>
</xsl:stylesheet>